/*
 * @Author: 吴文洁 
 * @Date: 2020-07-14 15:43:00 
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-23 20:23:12
 * @Description: 大班直播、互动班课的直播课列表
 */

import React from 'react';
import { Table, Modal, Tooltip, Badge, message, Dropdown, Button } from 'antd';

import Bus from '@/core/bus';
import User from "@/core/user";
import User_t from "@/teacher/core/user";
import { PageControl } from "@/components";
// import { LIVE_SHARE_MAP } from '@/common/constants/academic/cloudClass';
import DownloadLiveModal from '@/components/DownloadLiveModal';

import LiveStudentListModal from '../modal/LiveStudentListModal';
import CheckBalanceModal from '../modal/CheckBalanceModal';
import StartLiveModal from '../modal/StartLiveModal';
import ClassRecordModal from '../modal/ClassRecordModal';
import PlayBackRecordModal from '../modal/PlayBackRecordModal';
import ManageCoursewareModal from '../modal/ManageCoursewareModal';
import ShareLiveModal from '../modal/ShareLiveModal';
import AccountChargeModal from '../modal/AccountChargeModal';
import SelectStudent from '../modal/select-student';

import './LiveCourseList.less';

const { teacherId, instId, adminId, adminName, name } = window.currentUserInstInfo;
const isTeacher = !!teacherId;

const courseStateShow = {
  UN_START: {
    code: 1,
    title: "待上课",
    color: "#FDBE31",
  },
  STARTING: {
    code: 2,
    title: "上课中",
    color: "#238FFF",
  },
  FINISH: {
    code: 3,
    title: "已完成",
    color: "#2FC83C",
  },
  EXPIRED: {
    code: 4,
    title: "未成功开课",
    color: "#CCCCCC",
  },
};

const ENV = process.env.DEPLOY_ENV || 'dev';

class LiveCourseList extends React.Component {
  
  constructor(props) {
    super(props);
    this.state = {
      url: '',
      editData: {},
      columns: [],
      isXiaoMai: false,
      downloadUrl: null,
      openCoursewareModal: false,
      currentTeacherId: teacherId
    }
  }

  componentWillMount() {
   
  }

  componentDidMount() {
   
  }
  
  // 获取直播间类型
  handleCheckLiveVersion = () => {
   
  }
  // 获取当前登录帐号的teacherId
  getTeacherId = () => {
    
  }

  getDownloadVersion() {
  
  }
  
  parseColumns = () => {
    const menu = (item) => (
      <div className="live-course-more-menu">
        <div
          onClick={() => {
            this.handleShowClassModal(item);
          }}
        >
          上课记录
        </div>
        {item.haveRecord === 'YES' &&
          <div
            onClick={() => {
              this.handleShowRepeatModal(item);
            }}
          >
            回放记录
          </div>
        }
      </div>
    );
    const columns = [
      {
        title: "课程名称",
        width: "20%",
        key: "courseName",
        dataIndex: "courseName",
        render: (val, record) => {
          const { coverUrl = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png' } = record;
          return (
            <div className="record__item">
              <img className="course-cover" src={coverUrl} />
              <span className="course-name">{val}</span>
            </div>
          )
          
        }
      },
      {
        title: "上课时间",
        width: "10%",
        key: "classTime",
        dataIndex: "classTime",
        render: (val, item) => {
          return `${formatDate("YYYY-MM-DD H:i",parseInt(item.startTime))}~${formatDate("H:i", parseInt(item.endTime))}`
        },
      },
      {
        title: "上课老师",
        width: "8%",
        key: "nickname",
        dataIndex: "nickname",
      },
      {
        title: (window.NewVersion && isXiaoMai) ? '学员管理' : '学员人数',
        width: "9%",
        key: "quota",
        dataIndex: "quota",
        render: (val, item) => {
          return (
            <span
              className="operate-text"
              onClick={() => {
                this.handleLinkToClassData(item)
              }}
            >
              {`${val}人`}
            </span>
          );
        },
      },
      {
        title: "课件管理",
        width: "7%",
        dataIndex: "courseware",
        render: (val, item, index) => {
          return item.channel === "XIAOMAI" ? (
            <span
              className="operate-text"
              onClick={() => {
                this.setState({
                  editData: item,
                  openCoursewareModal: true,
                });
              }}
            >
              {item.courseDocumentCount || 0}个
            </span>
          ) : (
            <span style={{ color: "#999" }}>暂不支持</span>
          );
        },
      },
      {
        title: "上课状态",
        width: "10%",
        key: "courseState",
        dataIndex: "courseState",
        render: (val, item) => {
          const { currentTeacherId } = this.state;
          const teacherPermission = item.teacherId === currentTeacherId;
          return (
            <div className="course-status">
              <Badge
                className="badge"
                color={courseStateShow[val].color}
                text={courseStateShow[val].title}
                status={val == 'STARTING' ? 'processing' : undefined}
              />
            </div>
          );
        },
      },
      {
        title: "操作",
        width: "20%",
        key: "operate",
        dataIndex: "operate",
        render: (val, item) => {

          return (
            <div className="operate">
              <div
                key="enter_live_room1"
                className="operate__item"
                onClick={() => { this.handleCheckPreEnterLiveRoom(item, teacherPermission ? 1 : 2) }}
              >进入直播间
              </div>
              <span className="operate__item split" key="enter_live_room1_split"> | </span>
              <div
                key="view_play_back"
                className="operate__item"
                onClick={() => { this.handleStartPlayBack(item); }}
              >查看回放</div>,

              <span className="operate__item split" key="view_play_back_split"> | </span>
              <div
                  key="share"
                  className="operate__item"
                  onClick={() => { this.handleShowShareModal(item); }}
                >
                  分享
                </div>,
              <span key="split1" className="operate__item split"> | </span>

          
              <div className="big-live">
                <Dropdown overlay={this.renderMoreOperate(item, isXiaoMai, otherPermission, isInteractive)}>
                  <span className="more-operate">
                    <span className="operate-text">更多</span>
                    <span
                      className="iconfont icon"
                      style={{ color: "#FC9C6B" }}
                    >
                      &#xe824;
                    </span>
                  </span>
                </Dropdown>
              </div>
            </div>
          )
        }
      }
    ];
  }

  renderMoreOperate = (item, isXiaoMai, otherPermission, isInteractive) => {
    return (
      <div className="live-course-more-menu">
          <div
          className="operate__item"
          onClick={() => this.handleRemindClass(item)}
          >群发通知</div>
          <div
            className="operate__item"
            onClick={() => this.handleEditLiveClass(item, isInteractive)}
          >编辑</div>
          <div
            className="operate__item"
            onClick={() => this.handleDeleteLiveClass(item.liveCourseId)}
          >删除</div>
       
        
      </div>
    )
  }

  // 显示添加学员的更多操作
  renderAddStuOverLay = (item) => {
    return (
      <div className="live-course-more-menu">
        <div
          className="operate__item"
          onClick={() => this.handleShowSelectStuModal(item, 'DEDUCTION')}
        >
          添加扣课时的学员
        </div>

        <div
          className="operate__item"
          onClick={() => this.handleShowSelectStuModal(item)}
        >
          添加不扣课时的学员
        </div>
      </div>
    )
  }



  render() {
    const { total, query, courseList, loading, type } = this.props;
    const { current, size } = query;

    const {
      openCoursewareModal, openDownloadModal, editData,
      downloadUrl, url, columns,
    } = this.state;

    return (
      <div className="live-course-list">
        <Table
          bordered
          size="middle"
          pagination={false}
          columns={columns}
          loading={loading}
          dataSource={courseList}
          rowKey={(row) => row.liveCourseId}
        />

        <div className="box-footer">
          <PageControl
            current={current - 1}
            pageSize={size}
            total={parseInt(total)}
            toPage={(page) => {
              const _query = {...query, current: page + 1};
              this.props.onChange(_query)
            }}
          />
        </div>
      </div>
    )
  }
}

export default LiveCourseList;