import React, { useEffect, useState } from 'react';
import { Modal, Button } from 'antd';
import qrcode from "@/libs/qrcode/qrcode.js";
import './StudentClassReportModal.less';


const StudentClassReportModal = (props) => {
  const url = window.CONFIG.parentHref[window.CONFIG.env];
  const previewUrl = `${url}#/live/pc-cloud-class-report?courseId=${props.courseId}&studentId=${props.studentId}`
  const mobileUrl = `${url}#/live/cloud-class-report?courseId=${props.courseId}&studentId=${props.studentId}`

  useEffect(() => {

    window.axios.Sales('public/businessShow/convertShortUrls', {
      urls: [mobileUrl]
    }).then((res) => {
      const { result = [] } = res;
      const qrcodeNode = new qrcode({
        text: result[0].shortUrl,
        size: 106
      });
      document.querySelector('#qrcode').appendChild(qrcodeNode)
    })
  }, [])

  return (
    <Modal
      visible={true}
      title={props.studentId? "TA的课堂报告":"老师的课堂报告"}
      width={560}
      onCancel={props.onCancel}
      className="student-class-report-modal"
      footer={ <div onMouseEnter={(e) => {
        e.preventDefault();
      }}
      >
        <Button
          key="cancel"
          onMouseEnter={(e) => {
            e.preventDefault();
            let qrcode = document.getElementsByClassName("qrcode")[0];
            qrcode.style.display = "block";
          }}
          onMouseLeave={(e) => {
            e.preventDefault();
            let qrcode = document.getElementsByClassName("qrcode")[0];
            qrcode.style.display = "none";
          }}
        >
          分享TA的课堂报告
        </Button>
      </div>}
      >
      <div className="modal-content">
        <iframe
          src={previewUrl}
          style={{ width: '100%', height: '70vh', border: 'none' }}
        />
      </div>
      <div className="qrcode">
        <div className="qrcode-text">微信扫码查看/分享</div>
        <div id="qrcode"></div>
        <div className="triangle"></div>
      </div>
  </Modal>
  )
}

export default StudentClassReportModal;