/*
 * @Author: wufan
 * @Date: 2020-11-04 15:53:17
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-16 16:32:13
 */

import React, { useEffect, useState } from 'react';
import { Tooltip } from 'antd';
import Lottie from "lottie-web";
import './TeacherClassReportPage.less';

const TeacherClassReportPage = (props) => {
  const [liveType, setLiveType] = useState('');
  const [teacherName, setTeacherName] = useState('');
  const [courseName, setCourseName] = useState(''); // 课次名称
  const [classTime, setClassTime] = useState(); // 实际上课时间
  const [actualStartTime, setActualStartTime] = useState(); // 实际开始上课时间
  const [actualEndTime, setActualEndTime] = useState(); // 实际开始上课时间

  const [actualSignNum, setActualSignNum] = useState(); //  实到人数
  const [allStudentNum, setAllStudentNum] = useState(); //  应到人数
  const [signRate, setSignRate] = useState(); //  到课比例
  const [lateStudentNum, setLateStudentNum] = useState(); //  迟到人数
  const [lateRate, setLateRate] = useState(); //  迟到比例

  const [allConsumeNum, setAllConsumeNum] = useState(); //  扣课时应到
  const [actualConsumeNum, setActualConsumeNum] = useState(); //  扣课时实到
  const [consumeClassHour, setConsumeClassHour] = useState(); //  扣课时数
  const [allNoneHourNum, setAllNoneHourNum] = useState(); //  不扣课时总人数
  const [actualNoneHourNum, setActualNoneHourNum] = useState(); //  不扣课时实到人数

  const [questionCount, setQuestionCount] = useState(); //  题目数
  const [correctRate, setCorrectRate] = useState(); //  正确率
  const [studentAnswerCount, setStudentAnswerCount] = useState(); //  答题人次
  const [joinQuestionRate, setJoinQuestionRate] = useState(); //  答题参与率

  const [trophyCount, setTrophyCount] = useState(); //  总共发放奖杯数
  const [trophyStudentCount, setTrophyStudentCount] = useState(); //  获得奖杯学生数

  const [raiseHand, setRaiseHand] = useState(); //  举手数
  const [upPodiumCount, setUpPodiumCount] = useState(); //  上台数

  const [allIntegralNum, setAllIntegralNum] = useState(); //  总发放积分数
  const [integralStudentNum, setIntegralStudentNum] = useState(); //  积分获取人数
  const [signIntegralNum, setSignIntegralNum] = useState(); //  到课发放积分数
  const [signIntegralStudentNum, setSignIntegralStudentNum] = useState(); //  到课获得积分人数
  const [interactiveIntegralNum, setInteractiveIntegralNum] = useState(); //  互动发放积分数
  const [interactiveIntegralStudentNum, setInteractiveIntegralStudentNum] = useState(); //  互动获得积分人数
  const [consumeClassTime, setConsumeClassTime] = useState(); //  互动获得积分人数
  const [consumeHourNum, setConsumeHourNum] = useState(); //  扣课的课时数
  const [loading, setLoading] = useState(true); //  扣课的课时数

    useEffect(() => {
      var animation = Lottie.loadAnimation({
        path: "https://image.xiaomaiketang.com/xm/z32ddE2hNw.json",
        name: "test",
        renderer: "svg",
        loop: true,
        autoplay: true,
        container: document.getElementById("lottie-box")
      });
      
      // 客户端调用客服去掉
      if(!props.courseId){
        const kefu = document.getElementsByClassName("zhiCustomBtn")[0];
        kefu.style.display = "none";
      } 
        let courseId = props.courseId || window.location.href.slice(window.location.href.indexOf("?")).split("=")[1];
      axios.Apollo('anon/businessLive/getClassReport',{courseId}).then((res) => {
        const data = res.result || {};

        if (data.teacherName) {
          setLoading(false);
        }
        let {
          teacherName,
          courseName,
          liveType,
          classTime,
          actualStartTime,
          actualEndTime,
          actualSignNum,
          allStudentNum,
          signRate,
          lateStudentNum,
          lateRate,
          allConsumeNum,
          actualConsumeNum,
          consumeClassHour,
          allNoneHourNum,
          actualNoneHourNum,
          questionCount,
          correctRate,
          studentAnswerCount,
          joinQuestionRate,
          trophyCount,
          trophyStudentCount,
          raiseHand,
          upPodiumCount,
          allIntegralNum,
          integralStudentNum,
          signIntegralNum,
          signIntegralStudentNum,
          interactiveIntegralNum,
          interactiveIntegralStudentNum,
          consumeClassTime,
          consumeHourNum
        } = res.result;
        setLiveType(liveType);
        setTeacherName(teacherName);
        setCourseName(courseName);
        setActualStartTime(actualStartTime);
        setActualEndTime(actualEndTime);
        setClassTime(classTime);
        setActualSignNum(actualSignNum);
        setAllStudentNum(allStudentNum);
        setSignRate(signRate);
        setLateStudentNum(lateStudentNum);
        setLateRate(lateRate);
        setAllConsumeNum(allConsumeNum);
        setActualConsumeNum(actualConsumeNum);
        setConsumeClassHour(consumeClassHour);
        setAllNoneHourNum(allNoneHourNum);
        setActualNoneHourNum(actualNoneHourNum);
        setQuestionCount(questionCount);
        setCorrectRate(correctRate);
        setStudentAnswerCount(studentAnswerCount);
        setJoinQuestionRate(joinQuestionRate);
        setTrophyCount(trophyCount);
        setTrophyStudentCount(trophyStudentCount);
        setRaiseHand(raiseHand);
        setUpPodiumCount(upPodiumCount);
        setAllIntegralNum(allIntegralNum);
        setIntegralStudentNum(integralStudentNum);
        setSignIntegralNum(signIntegralNum);
        setSignIntegralStudentNum(signIntegralStudentNum);
        setInteractiveIntegralNum(interactiveIntegralNum);
        setInteractiveIntegralStudentNum(interactiveIntegralStudentNum);
        setConsumeClassTime(consumeClassTime);
        setConsumeHourNum(consumeHourNum);
      });
    }, []);

  const renderSignInTooltip = () => {
    return (
      <div>
        学员上课总时长达到<span className="class-high-light">{consumeClassTime}</span>分钟，即视为学员“到课”
      </div>
    );
  };

  const renderLateTooltip = () => {
    return (
      <div>
        老师点击开始上课后<span className="class-high-light">{' 3 '}</span>分钟之后，才进入课堂的到课学员
      </div>
    );
  };

  const renderTotalTooltip = () => {
    return (
      <div>
        “到课”学员扣<span className="class-high-light">{consumeHourNum}</span>课时
      </div>
    );
  };

  return (
    <div className="teacher-class-report-page">
      <div className="teacher-title">
        <div className="teacher-name">{teacherName}</div><div className="text">老师，工作辛苦了，这是本节课的课堂报告~</div>
      </div>

      <div className="class-detail">
        <div className="class-title">{courseName}</div>
        <div className="class-duration">{`${moment(actualEndTime).format('YYYY')}年${moment(
          actualEndTime,
        ).format('MM')}月${moment(actualEndTime).format('D')}日(${moment(actualEndTime).format(
          'dddd',
        )}) ${moment(actualStartTime).format('HH:mm')}-${moment(actualEndTime).format(
          'HH:mm',
        )} (${classTime}分钟)`}</div>
      </div>

      <div className="sign-in-detail">
        <div className="title">到课情况</div>
        <div className="content">
          <div className="rate-block">
            <div className="item">
              <div className="rate">
                {actualSignNum}
                <span className="tiny">/{allStudentNum}</span>
              </div>
              <div className="explaination">
                实到/应到人数
                <Tooltip title={renderSignInTooltip()} placement="bottom">
                  <i className="icon iconfont" style={{ marginLeft: '5px' }}>
                    &#xe6f0;
                  </i>
                </Tooltip>
              </div>
            </div>
            <div className="item">
              <div className="rate">{signRate}%</div>
              <div className="explaination">到课比例</div>
            </div>
            <div className="item">
              <div className="rate">{lateStudentNum}</div>
              <div className="explaination">
                迟到人数
                <Tooltip title={renderLateTooltip()} placement="bottom">
                  <i className="icon iconfont" style={{ marginLeft: '5px' }}>
                    &#xe6f0;
                  </i>
                </Tooltip>
              </div>
            </div>
            <div className="item">
              <div className="rate">{lateRate}%</div>
              <div className="explaination">迟到率</div>
            </div>
          </div>

          <div className="progress-block">
            {!!allConsumeNum && (
              <div className="item">
                <div className="tip">
                  <div className="text">
                    <span className="tip-title">扣课时</span>实到/应到人数
                  </div>
                  <div className="num">
                    <span className="left-num">{actualConsumeNum}</span>/{allConsumeNum}
                  </div>
                </div>
                <div className="progress">
                  <div className="up-progress" style={{width:`${(actualConsumeNum/allConsumeNum *100)}%`}}></div>
                  <div className="down-progress"></div>
                </div>
              </div>
            )}

            {!!allConsumeNum && (
              <div className="total-class">
                <div className="text">
                  <span className="tip-title">总扣除课时</span>(超上不计入)
                  <Tooltip title={renderTotalTooltip()} placement="bottom">
                    <i className="icon iconfont" style={{ marginLeft: '5px' }}>
                      &#xe6f0;
                    </i>
                  </Tooltip>
                </div>{' '}
                <div className="num">
                  <span className="left-num">{consumeClassHour}课时</span>
                </div>
              </div>
            )}

            {!!allNoneHourNum && (
              <div className="item">
                <div className="tip">
                  <div className="text">
                    <span className="tip-title">不扣课时</span>实到/应到人数
                  </div>
                  <div className="num">
                    <span className="left-num">{actualNoneHourNum}</span>/{allNoneHourNum}
                  </div>
                </div>
                <div className="progress">
                  <div className="up-progress" style={{width:`${(actualNoneHourNum/allNoneHourNum *100)}%`}}></div>
                  <div className="down-progress"></div>
                </div>
              </div>
            )}
          </div>
        </div>
      </div>

      <div className="class-data-detail">
        <div className="title">课堂数据</div>
        <div className="content">
          <div className="data-block">
            <div className="item">
              <img src="https://image.xiaomaiketang.com/xm/zyDZaSMYSH.png" alt="" />
              <div className="content">
                <div className="one">
                  共发起了<span className="large-line-height">{questionCount}</span>
                  次答题，平均正确率达
                  <span className="large-line-height">{correctRate}%</span>
                </div>
                <div className="two">
                  参与答题人次<span className="line-height">{studentAnswerCount}</span>，参与率
                  <span className="line-height">{joinQuestionRate}%</span>（仅计算到课学员）
                </div>
              </div>
            </div>

            {(liveType === 'LARGE_CLASS_INTERACTION' || liveType === "SMALL_CLASS_INTERACTION") && (
              <div className="item">
                <img src="https://image.xiaomaiketang.com/xm/QXyjKpBrGX.png" alt="" />
                <div className="content">
                  <div className="one">
                    共发放了<span className="large-line-height">{trophyCount}</span>个奖杯
                  </div>
                  <div className="two">
                    共有<span className="line-height">{trophyStudentCount}</span>个学生获得了奖杯
                  </div>
                </div>
              </div>
            )}

            {(liveType === 'LARGE_CLASS_INTERACTION' || liveType === "SMALL_CLASS_INTERACTION") && (
              <div className="item column-center">
                <img src="https://image.xiaomaiketang.com/xm/YrkH82fh86.png" alt="" />
                <div className="content">
                  <div className="two">
                    共计举手人次<span className="line-height">{raiseHand}</span> {liveType === "LARGE_CLASS_INTERACTION" && <span>，上台人次
                    <span className="line-height">{upPodiumCount}</span></span>}
                  </div>
                </div>
              </div>
            )}

            <div className="item">
              <img src="https://image.xiaomaiketang.com/xm/TieCG8wkyn.png" alt="" />
              <div className="content">
                <div className="one">
                  共计发放积分<span className="large-line-height">{allIntegralNum}</span>,有
                  <span className="large-line-height">{integralStudentNum}</span>人获得了积分
                </div>
                <div className="two">
                  通过“到课”发放积分<span className="line-height">{signIntegralNum}</span>，有
                  <span className="line-height">{signIntegralStudentNum}</span>人获得
                </div>
                <div className="three">
                  通过“互动”发放积分<span className="line-height">{interactiveIntegralNum}</span>
                  ，有<span className="line-height">{interactiveIntegralStudentNum}</span>人获得
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      { loading &&  <div className="class-loading-page">
      <div className="loading-box">
        <div id="lottie-box"></div>
        <span className="box-tip">正在努力生成报告中...</span>
      </div>
    </div>}
    </div>
  );
};

export default TeacherClassReportPage;
