/*
 * @Author: 吴文洁
 * @Date: 2020-07-23 14:54:16
 * @LastEditors: fusanqiasng
 * @LastEditTime: 2021-05-24 21:02:21
 * @Description: 大班直播课预览弹窗
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */

import React from "react";
import { Modal, Tabs } from "antd";
import moment from "moment";
import ChapterList from "../video-course/components/ChapterList";
import "./PreviewCourseModal.less";

const { TabPane } = Tabs;
const courseStateShow = {
  UN_START: {
    title: "待开课",
  },
  STARTING: {
    title: "上课中",
  },
  FINISH: {
    title: "已完成",
  },
  EXPIRED: {
    code: 4,
    title: "未成功开课",
    color: "#CCCCCC",
  },
};
class PreviewCourseModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      activeTab: "courseChapter",
    };
  }
  dealTimeDuration = (time) => {
    const diff = Math.floor(time % 3600);
    let hours = Math.floor(time / 3600);
    let mins = Math.floor(diff / 60);
    let seconds = Math.floor(time % 60);
    hours = hours < 10 ? "0" + hours : hours;
    mins = mins < 10 ? "0" + mins : mins;
    seconds = seconds < 10 ? "0" + seconds : seconds;
    return hours + ":" + mins + ":" + seconds;
  };
  dealWithTime = (startTime, endTime) => {
    const startDate = new Date(Number(startTime));
    const endDate = new Date(Number(endTime));

    const year = startDate.getFullYear();
    const month =
      startDate.getMonth() + 1 < 10
        ? `0${startDate.getMonth() + 1}`
        : startDate.getMonth() + 1;
    const day =
      startDate.getDate() < 10
        ? `0${startDate.getDate()}`
        : startDate.getDate();

    const startHour =
      startDate.getHours() < 10
        ? `0${startDate.getHours()}`
        : startDate.getHours();
    const startMinute =
      startDate.getMinutes() < 10
        ? `0${startDate.getMinutes()}`
        : startDate.getMinutes();

    const endHour =
      endDate.getHours() < 10 ? `0${endDate.getHours()}` : endDate.getHours();
    const endMinute =
      endDate.getMinutes() < 10
        ? `0${endDate.getMinutes()}`
        : endDate.getMinutes();

    const liveDateStr = `${year}-${month}-${day}`;
    const startTimeStr = `${startHour}:${startMinute}`;
    const endTimeStr = `${endHour}:${endMinute}`;

    return {
      liveDateStr,
      startTimeStr,
      endTimeStr,
    };
  };

  render() {
    const {
      courseBasicInfo,
      courseClassInfo = {},
      courseIntroInfo,
      type,
      courseState,
      courseChapterList = [],
    } = this.props;
    const { coverUrl, courseName, scheduleVideoUrl, videoDuration } =
      courseBasicInfo;
    const {
      liveDate,
      calendarTime,
      startTime,
      endTime,
      timeHorizonStart,
      timeHorizonEnd,
      teacherName,
    } = courseClassInfo;
    const { introduce } = courseIntroInfo;
    let { activeTab } = this.state;

    let liveDateStr, startTimeStr, endTimeStr;

    if (type === "add") {
      const _liveDate = moment(calendarTime[0]).format("YYYY-MM-DD");
      console.log("_liveDate", _liveDate);
      const _timeHorizonStart = moment(startTime).format("HH:mm");
      const _timeHorizonEnd = moment(endTime).format("HH:mm");
      const _startTime = moment(_liveDate + " " + _timeHorizonStart).format(
        "x"
      );
      const _endTime = moment(_liveDate + " " + _timeHorizonEnd).format("x");
      const {
        liveDateStr: _liveDateStr,
        startTimeStr: _startTimeStr,
        endTimeStr: _endTimeStr,
      } = this.dealWithTime(_startTime, _endTime);

      liveDateStr = _liveDateStr;
      startTimeStr = _startTimeStr;
      endTimeStr = _endTimeStr;
    } else {
      const _liveDate = moment(liveDate).format("YYYY-MM-DD");
      const _timeHorizonStart = moment(timeHorizonStart).format("HH:mm");
      const _timeHorizonEnd = moment(timeHorizonEnd).format("HH:mm");
      const startTime = moment(_liveDate + " " + _timeHorizonStart).format("x");
      const endTime = moment(_liveDate + " " + _timeHorizonEnd).format("x");
      const {
        liveDateStr: _liveDateStr,
        startTimeStr: _startTimeStr,
        endTimeStr: _endTimeStr,
      } = this.dealWithTime(startTime, endTime);

      liveDateStr = _liveDateStr;
      startTimeStr = _startTimeStr;
      endTimeStr = _endTimeStr;
    }

    return (
      <Modal
        title="预览"
        visible={true}
        width={680}
        onCancel={this.props.close}
        footer={null}
        maskClosable={false}
        closeIcon={
          <span className="icon iconfont modal-close-icon">&#xe6ef;</span>
        }
        className="preview-live-course-modal"
      >
        <div className="container__wrap">
          <div className="container">
            <div className="container__header">
              {type === "videoCourse" ? (
                <video
                  controls
                  src={courseChapterList.length && courseChapterList[0].mediaUrl || scheduleVideoUrl }
                  poster={
                    coverUrl
                      ? coverUrl
                      : "https://image.xiaomaiketang.com/xm/mt3ZQRxGKB.png"
                  }
                  className="course-url"
                />
              ) : (
                <img src={coverUrl} className="course-cover" />
              )}
            </div>
            {type === "videoCourse" ? (
              <div className="container__body">
                <div className="title__name">{courseName}</div>
                {videoDuration && (
                  <div>视频时长：{this.dealTimeDuration(videoDuration)}</div>
                )}
              </div>
            ) : (
              <div className="container__body">
                <div className="container__body__title">
                  <div className="title__name">{courseName}</div>
                  <div className="title__state">
                    {courseStateShow[courseState].title}
                  </div>
                </div>
                <div className="container__body__time">
                  <span className="time__label">上课时间：</span>
                  <span className="time__value">
                    {[
                      <span>{liveDateStr}&nbsp;</span>,
                      <span>
                        {startTimeStr}~{endTimeStr}
                      </span>,
                    ]}
                  </span>
                </div>
                <div className="container__body__teacher">
                  <span className="teacher__label">上课老师：</span>
                  <span className="teacher__value">{teacherName}</span>
                </div>
              </div>
            )}

            <div className="container__introduction">
              <Choose>
                <When condition={type === "videoCourse"}>
                  <Tabs
                    activeKey={activeTab}
                    onChange={(key) => {
                      this.setState({
                        activeTab: key,
                      });
                    }}
                  >
                    <TabPane tab="课程目录" key="courseChapter"></TabPane>
                    <TabPane tab="课程简介" key="courseIntro"></TabPane>
                  </Tabs>
                </When>
                <Otherwise>
                  <div className="container__introduction__title">
                    直播课简介
                  </div>
                </Otherwise>
              </Choose>

              <Choose>
                <When condition={type === "videoCourse"}>
                  {activeTab === "courseChapter" && (
                    <div className="container__chapter">
                      {
                        <ChapterList
                          chapterType="VIDEO"
                          courseChapterList={courseChapterList}
                        />
                      }
                    </div>
                  )}
                  {activeTab === "courseIntro" && (
                    <div className="container__introduction__list editor-box">
                      <div
                        className="intro-item text"
                        dangerouslySetInnerHTML={{
                          __html: introduce,
                        }}
                      />
                    </div>
                  )}
                </When>
                <Otherwise>
                  <div className="container__introduction__list editor-box">
                    <div
                      className="intro-item text"
                      dangerouslySetInnerHTML={{
                        __html: introduce,
                      }}
                    />
                  </div>
                </Otherwise>
              </Choose>
            </div>
          </div>
        </div>
      </Modal>
    );
  }
}

export default PreviewCourseModal;
