import React from 'react';
import { Select } from 'antd';
import moment from 'moment'
import Service from "@/common/js/service";
import User from '@/common/js/user';
import './Home.less';

const Option = Select.Option;

class Home extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      scheduleType: 'LIVE',
      list: [],
      dataList: [],
      incCustomerNum: 0,
      incLiveCourseNum: 0,
      incVideoCourseNum: 0,
      liveCourseNum: 0,
      totalCustomerNum: 0,
      videoCourseNum: 0,
      timeRange: '7',
      studyTimeRange: '7',
    }
  }

  componentDidMount() {
    this.getPanelInfo();
    this.getStudyInfo();
    this.getHotCourse();
  }

  getHotCourse() {
    const { timeRange, scheduleType } = this.state;
    const data = {
      hotNum: 5,
      scheduleType,
      storeId: User.getStoreId(),
      timeRange,
    }
    Service.Hades('public/courseCloud/hotCourse', data).then((res) => {
      if (res.success) {
        this.setState({
          list: res.result
        })
      }
    })
  }

  getStudyInfo() {
    const { studyTimeRange } = this.state;
    Service.Hades('public/hades/studyInfo', { storeId: User.getStoreId(), timeRange: studyTimeRange }).then((res) => {
      if (res.success) {
        this.setState({
          dataList: res.result
        })
      }
    });
  }

  getPanelInfo() {
    Service.Hades('public/hades/storePanelInfo', { storeId: User.getStoreId() }).then((res) => {
      if (res.success) {
        this.setState({
          incCustomerNum: res.result.incCustomerNum,
          incLiveCourseNum: res.result.incLiveCourseNum,
          incVideoCourseNum: res.result.incVideoCourseNum,
          liveCourseNum: res.result.liveCourseNum,
          totalCustomerNum: res.result.totalCustomerNum,
          videoCourseNum: res.result.videoCourseNum,
        })
      }
    })
  }

  showNumber(index) {
    switch (index) {
      case 0:
        return 'https://image.xiaomaiketang.com/xm/D64QhNn74S.png';
      case 1:
        return 'https://image.xiaomaiketang.com/xm/Qfib4mnGJT.png';
      case 2:
        return 'https://image.xiaomaiketang.com/xm/8jKXHyrDaG.png';
    
      default:
        return 'https://image.xiaomaiketang.com/xm/D64QhNn74S.png';
    }
  }

  render() {
    const {
      list,
      incCustomerNum,
      incLiveCourseNum,
      incVideoCourseNum,
      liveCourseNum,
      totalCustomerNum,
      videoCourseNum,
      timeRange,
      scheduleType,
    } = this.state;
    return (
      <div className="home-page">
        <div className="home-title">数据概况</div>
        <div className="data-box">
          <div className="data-item">
            <div className="header">
              <img className="header-icon" src="https://image.xiaomaiketang.com/xm/wAaFtjeRsM.png" />
              <span className="header-word">用户总数 (人)</span>
            </div>
            <div className="data-number">{totalCustomerNum}</div>
            <div className="data-footer">
              <span className="footer-word">本月新增</span>
              {incCustomerNum > 0 &&
                <span className="icon iconfont">&#xe635;</span>
              }
              <span className="footer-number">{incCustomerNum}</span>
            </div>
          </div>
          <div className="data-item course-data">
            <div className="header">
              <img className="header-icon" src="https://image.xiaomaiketang.com/xm/jPrRhw8EMF.png" />
              <span className="header-word">课程总数 (个)</span>
            </div>
            <div className="data-number">{videoCourseNum + liveCourseNum}</div>
            <div className="course-box">
              <div className="course-item">
                <div className="course-title">直播课</div>
                <div className="data">
                  <span className="course-number">{liveCourseNum}</span>
                  <span className="course-word">本月新增</span>
                  {incLiveCourseNum > 0 &&
                    <span className="icon iconfont">&#xe635;</span>
                  }
                  <span className="add-number">{incLiveCourseNum}</span>
                </div>
              </div>
              <div className="course-item">
                <div className="course-title">视频课</div>
                <div className="data">
                  <span className="course-number">{videoCourseNum}</span>
                  <span className="course-word">本月新增</span>
                  {incVideoCourseNum > 0 &&
                    <span className="icon iconfont">&#xe635;</span>
                  }
                  <span className="add-number">{incVideoCourseNum}</span>
                </div>
              </div>
              <div className="course-item">
                <div className="course-title">图文课</div>
                <div className="data">
                  <span className="course-number">0</span>
                  <span className="course-word">本月新增</span>
                  {false &&
                    <span className="icon iconfont">&#xe635;</span>
                  }
                  <span className="add-number">0</span>
                </div>
              </div>
              <div className="course-item">
                <div className="course-title">线下课</div>
                <div className="data">
                  <span className="course-number">0</span>
                  <span className="course-word">本月新增</span>
                  {false &&
                    <span className="icon iconfont">&#xe635;</span>
                  }
                  <span className="add-number">0</span>
                </div>
              </div>
            </div>
          </div>
          <div className="data-item">
            <div className="header">
              <img className="header-icon" src="https://image.xiaomaiketang.com/xm/jZf3GNY5tY.png" />
              <span className="header-word">培训计划总数 (个)</span>
            </div>
            <div className="data-number">0</div>
            <div className="data-footer">
              <span className="footer-word">本月新增</span>
              {false &&
                <span className="icon iconfont">&#xe635;</span>
              }
              <span className="footer-number">0</span>
            </div>
          </div>
          <div className="data-item">
            <div className="header">
              <img className="header-icon" src="https://image.xiaomaiketang.com/xm/3CfrPs23Re.png" />
              <span className="header-word">考试总数 (个)</span>
            </div>
            <div className="data-number">0</div>
            <div className="data-footer">
              <span className="footer-word">本月新增</span>
              {false &&
                <span className="icon iconfont">&#xe635;</span>
              }
              <span className="footer-number">0</span>
            </div>
          </div>
        </div>
        <div className="home-title">学习概况</div>
        <div className="study-box">
          <div className="study-item">
            <div className="study-title">课程学习排行榜</div>
            <div className="study-header">
              <div className="study-tab">
                <span 
                  className={`tab${scheduleType === 'LIVE' ? ' selected' : ''}`}
                  onClick={() => this.setState({ scheduleType: 'LIVE' }, () => this.getHotCourse())}
                >直播课</span>
                <span 
                  className={`tab${scheduleType === 'VOICE' ? ' selected' : ''}`}
                  onClick={() => this.setState({ scheduleType: 'VOICE' }, () => this.getHotCourse())}
                >视频课</span>
              </div>
              <div className="study-select">
                <span className="select-word">（{moment().subtract(timeRange, 'day').format('MM.DD')} ~ {moment().format('MM.DD')}）</span>
                <Select
                  style={{ width: 88 }}
                  value={timeRange}
                  onChange={(value) => {
                    this.setState({ timeRange: value }, () => this.getHotCourse());
                  }}
                >
                  <Option value="7">近7天</Option>
                  <Option value="15">近15天</Option>
                  <Option value="30">近30天</Option>
                </Select>
              </div>
            </div>
            {_.isEmpty(list) ?
              <div className="study-empty">
                <img src="https://image.xiaomaiketang.com/xm/7fNziTkEaA.png" />
                <div>暂无课程上榜</div>
              </div>
              : list.map((item, index) => (
                <div className={`table-item${index % 2 ? '' : ' odd'}`} key={item.id}>
                  {index < 3 ?
                    <img src={this.showNumber(index)} className="table-image" />
                    : <span className="table-number">{index + 1}</span>
                  }
                  <div className="table-data">
                    <div className="table-name">{item.courseName}</div>
                    <div className="table-tag">{item.categoryName}</div>
                  </div>
                  <span className="table-study">{item.studyNum || 0}人已学习</span>
                </div>
                ))
            }
          </div>
          <div className="study-item">
            <div className="study-title">培训计划完成情况
               <span></span>
            </div>

          </div>
        </div>
        <div className="study-chart">
          <div className="study-title">学习人数与时长</div>

        </div>
      </div>
    )
  }
}

export default Home;