/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: wufan
 * @LastEditTime: 2021-05-30 15:57:40
 * @Description: 学员管理页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import { PageControl } from "@/components";
import { Table, Input, DatePicker, Select, Button, message, Tooltip } from "antd";
import StoreService from "@/domains/store-domain/storeService";
import User from "@/common/js/user";
import ChooseMembersModal from "./modal/ChooseMembersModal";

import "./UserManagePage.less";
import moment from "moment";
const { Option } = Select;
const { Search } = Input;
const { RangePicker } = DatePicker;

declare var window: any;

function LimitTip(props:{total:number,uplimit?:number}) {

  const [isOver, setIsOver] = useState(true)

  return (
    <div className="limit-tip">
      <div className="always">本学院学员共<span style={{color:"#333333",fontWeight:"bold"}}>{props.total}</span>人
      <Tooltip overlayStyle={{maxWidth:"587px",width:"587px"}} placement="topLeft" arrowPointAtCenter title={()=>{ return (<div><div>1、数据为当前学院的员工数，若学员存在多个学院，企业人数只统计为1人；</div><div>2、若一个学员既用「企业微信」登录学习又用「微信」登录学习，企业人数将统计为2人。</div></div>)}}>
        <span className="icon iconfont" style={{cursor:"pointer",marginLeft:"4px",color:"#bfbfbf"}}>&#59449;</span>
      </Tooltip>
      {
        isOver ? (
          <>
          <div style={{marginLeft:"14px",display:"inline-block"}}>当前企业使用人数已达到上限 (<span style={{color:"#333333",fontWeight:"bold"}}>{props.uplimit}</span>人)，将无法添加新员工、新学员，如需增加人数限制，请联系小麦企学院服务平台。</div>
          <div className="renew-text">立即续费<span className="icon iconfont" style={{fontSize:"10px"}}>&#59291;</span>
          <div className="renew-popover">
          <div className="popover-arrow"><span className="popover-arrow-content"></span></div>
              <div className="qrcode">
                <img src="https://cdn.xiaomai5.com/qixueyuankehu.png" alt=""></img>
                <div className="des">微信/企业微信扫码续费</div>
              </div>
              <div className="phone"><svg style={{position:"relative",top:"2px",marginRight:"4px"}} viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path d="M512.651 3.78c-281.433 0-509.21 228.324-509.21 509.209 0 281.43 228.325 509.203 509.21 509.203 281.427 0 509.202-228.317 509.202-509.203 0.55-280.885-227.775-509.21-509.202-509.21z m198.205 743.553c-36.14 36.136-169.737 1.641-302.24-130.312-131.953-131.959-165.902-266.104-129.768-301.695 31.211-31.21 68.99-85.417 125.939-14.782 56.943 70.629 29.016 90.34-3.291 122.647-22.449 22.448 24.642 79.392 73.37 128.125 49.283 48.73 105.678 95.818 128.126 73.368 32.306-32.305 52.017-60.23 122.646-3.288 71.182 56.949 16.426 95.276-14.782 125.937z" p-id="4409" fill="#999999"></path></svg>
              咨询电话：19157875632</div>
            </div>
          </div>
          </>
        ) : ("")
      }
      </div>
    </div>
  )
}

function UserManagePage() {
  const [userList, setUserList] = useState([]);
  const [model, setModel] = useState<React.ReactNode>(null);
  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    nickName: "",
    phone: "",
    registerBegin: null,
    registerEnd: null,
    sourceEnum: undefined,
  });
  const [total, setTotal] = useState(0);

  useEffect(() => {
    if (!User.getEnterpriseId()) {
      window.RCHistory.replace('/user-manage');
    }
  }, [])

  useEffect(() => {
    getUserList();
  }, [query]);

  function getUserList() {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getUserList(_query).then((res: any) => {
      setUserList(res.result.records);
      setTotal(res.result.total);
    });
  }

  function parseColumn() {
    const list = [
      {
        title: "学员姓名",
        dataIndex: "nickName",
        render: (val: string, item: any) => {
          return (
            <div className="coupon-info">
              <span className="title">{val}</span>
              <span
                className="tag"
                style={{ color: item.sourceEnum === 'WORK_WE_CHAT' ? '#2966FF' : '#1DCC65'}}
              >{item.sourceEnum === 'WORK_WE_CHAT' ? '@企业微信' : '@微信'}</span>
            </div>
          );
        },
      },
      {
        title: "手机号",
        dataIndex: "phone",
        key: "phone",
        render: (val: string) => {
          return <div>{val || '-'}</div>;
        },
      },
      {
        title: "注册时间",
        dataIndex: "created",
        key: "created",
        render: (val: string) => {
          return <div>{moment(val).format("YYYY-MM-DD HH:mm:ss")}</div>;
        },
      },
    ];
    if (User.getUserRole() !== 'StoreManager') {
      list.splice(1, 1);
    }
    return list;
  }

  function handleToAddEmployee() {
    const model: React.ReactNode = (
      <ChooseMembersModal
        isOpen={true}
        type="CUSTOMER"
        handleChooseModal={(bool: any) => {
          setModel(null)
          if (bool) {
            message.success('添加成功')
            getUserList();
          }
        }}
      />
    );
    setModel(model);
  }


  return (
    <div className=" page user-manage-page">
        <div className="content-header">学员管理</div>
        <div className="box">
          <div className="box-header">
            <div className="header-item">
              <span className="item-name">搜索学员：</span>
              <Search
                style={{
                  width: 300,
                }}
                placeholder="搜索学员姓名/手机号"
                onSearch={(value) => {
                  const _query = { ...query };
                  if (value) {
                    console.log("value", value);
                    const isPhone = (value || "").match(/^\d+$/);
                    const name = isPhone ? "phone" : "nickName";
                    _query.nickName = "";
                    _query.phone = "";
                    _query[name] = value;
                    _query.current = 0;
                  } else {
                    _query.nickName = "";
                    _query.phone = "";
                    _query.current = 0;
                  }
                  setQuery(_query);
                }}
                enterButton={<span className="icon iconfont">&#xe832;</span>}
              />

            </div>
            <div className="header-item">
              <span className="item-name">学员来源：</span>
                <Select
                  style={{ width: '100%' }}
                  placeholder="请选择"
                  allowClear
                  onChange={(value) => {
                    const _query: any = _.clone(query);
                    _query.sourceEnum = value;
                    _query.current = 0;
                    setQuery(_query);
                  }}
                >
                <Option value="WORK_WE_CHAT">企业微信</Option>
                <Option value="WE_CHAT">微信</Option>
              </Select>
            </div>

            <div className="header-item">
              <span className="item-name">注册时间：</span>
              <RangePicker
                style={{ flex: 1, width: "auto" }}
                value={
                  query.registerBegin
                    ? [moment(query.registerBegin), moment(query.registerEnd)]
                    : null
                }
                format={"YYYY-MM-DD"}
                onChange={(dates: any) => {
                  const _query = _.clone(query);
                  _query.registerBegin = dates ? dates[0].startOf("day").valueOf() : null;
                  _query.registerEnd = dates ? dates[1].endOf("day").valueOf() : null;
                  _query.current = 0;
                  setQuery({
                    ..._query
                      });
                }}
              />
            </div>
        </div>
        {(User.getUserRole() === 'CloudManager' || User.getUserRole() ==='StoreManager') &&
          <Button
            type="primary"
            style={{ marginBottom: 12 }}
            onClick={() => {
              handleToAddEmployee();
            }}
          >添加学员</Button>
        }
        <LimitTip total={total}/>
        <div className="box-body">
          <Table
            size={"middle"}
            pagination={false}
            dataSource={userList}
            columns={parseColumn()}
            rowKey={(item: any) => item.id}
            bordered
          />
        </div>
        <div className="box-footer">
          <PageControl
            current={query.current}
            pageSize={query.size}
            total={total}
            toPage={(page: any) => {
              const queryStates = _.clone(query);
              queryStates.current = page;
              setQuery(queryStates);
            }}
          />
        </div>
      </div>
      {model}
    </div>
  );
}

export default withRouter(UserManagePage);
