/*
 * @Author: wufan
 * @Date: 2020-11-27 16:21:49
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-07-28 10:15:37
 * @Description: Description
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useState, useEffect } from "react";
import { Modal,Form,Input,Button,message} from "antd";
import User from '@/common/js/user';
import StoreService from "@/domains/store-domain/storeService";
import { DepType }  from '@/domains/store-domain/constants';
import './AddOrEditPostGroupModal.less'
function AddOrEditPostGroupModal(props) {
  const [nameErrorMsg,setNameErrorMsg] = useState('');
  const [validateStatus,setValidateStatus] = useState('success');
  const [postGroupName,setPostGroupName] = useState('');
  useEffect(() => {
    
  },[]);
  function changePostGroupName(e){
    setValidateStatus('success');
    props.postGroupTreeData.map((item,index)=>{
        if(item.name === e.target.value){
            setValidateStatus('error');
            setNameErrorMsg('该岗位组已存在');
        }
        return item;
    })
    setPostGroupName(e.target.value);
  }

  function handleConfirm(){
    if(props.modalOperateType === 'add'){
      addGroup();
    }else{
      editGroup();
    }
  }
  function addGroup(){
    const { postGroupModalLevel,currentTab,currentGroupData,label} = props
    let parmas={
      depLevel:postGroupModalLevel,
      depType:DepType[currentTab],
      departmentName:postGroupName,
      enterpriseId:User.getEnterpriseId(),
      source:0,
      storeId:User.getStoreId(),
      userId:User.getUserId()
    }
    if(postGroupModalLevel===0){
      parmas.parentId = 0;
    }else{
      parmas.parentId = currentGroupData.id
    }
    StoreService.addDepartment(parmas).then((res) => {
      message.success(`${label}创建成功`)
      props.onConfirm();
    });
  }
  function editGroup(){
    const {postGroupModalLevel,currentTab,currentGroupData,label} = props
    let parmas={
      departmentLevel:postGroupModalLevel,
      departmentId:currentGroupData.id,
      depType:DepType[currentTab],
      departmentName:postGroupName,
      enterpriseId:User.getEnterpriseId(),
      source:0,
      storeId:User.getStoreId(),
      userId:User.getUserId()
    }
    if(postGroupModalLevel===0){
      parmas.parentId = 0;
    }else{
      parmas.parentId = currentGroupData.parentId
    }
    StoreService.editDepartment(parmas).then((res) => {
      message.success(`${label}修改成功`)
      props.onConfirm();
    });
  }
  return (
    <Modal
      visible={true}
      title={props.title}
      className="add-edit-post-group-modal"
      onCancel={props.onClose}
      width={448}
      footer={[
        <Button
            id='cancel_allot_btn'
            key="back" onClick={props.onClose}>取消</Button>,
        <Button
            id='confirm_allot_btn'
            key="submit"
            type="primary"
            onClick={() => {
                handleConfirm()
            }}>
            保存
        </Button>
      ]}
      maskClosable={false}
      closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
    >
     <Form
        labelCol={ {span:5 }}
     >
        <Form.Item
            // label={`${props.label}名称`}
            name={`${props.label}名称`}
            rules={[{ required: true}]}
            validateStatus={validateStatus}
            help={nameErrorMsg}
        >
        <Input type="text" placeholder={`请输入${props.label}名称（8个字以内）`} maxLength={8} style={{ width: 348 }}  
            defaultValue={props.modalOperateType==='edit'?props.currentGroupData.name:''}
            onChange={(e) => { 
            changePostGroupName(e);
        }} />
      </Form.Item>
     </Form>
    </Modal>
  );
}

export default AddOrEditPostGroupModal;
