import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Input,Checkbox} from "antd";
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user';
import WWOpenDataCom from '@/components/WWOpenDataCom';
import $  from 'jquery';
import './SearchUser.less'
const { Search } = Input;
function SearchUser(props) {
  const [dropDownVisible,setDropDownVisible]=useState(false);
  useEffect(()=>{
    documentClick();
  },[])
  function onFocus(e){
    setDropDownVisible(true);
  }

  function onChange(e){
    props.onChange(e.target.value)
  }
  function selectuser(e,item){
    if(e.target.checked){
      let _record = []
      _record.push(item)
      props.onSelect(_record)
    }
  }
  function selectDep(e,item){
    if(e.target.checked){
      props.onSelect(item.departmentUserVOList || []);
    }
  }
  function  documentClick(){
    document.onclick = function (e) {
      let _con =$('#search-user');
      if(!_con.is(e.target) && _con.has(e.target).length === 0){
        setDropDownVisible(false);
      }
    };
  }

  return (
    <div className="search-user" style={{width:'300px'}} id="search-user">
        <Search 
          placeholder='搜索成员'
          enterButton={<span className="icon iconfont">&#xe832;</span>}
          onFocus={(e)=>{onFocus(e)}}
          onChange={(e)=>{onChange(e)}}
          // onBlur={()=>{onBlur()}}
        />
        {dropDownVisible && 
        <div className="drop-down" style={{width:'100%'}}>
              <div className="drop-down__list">
                 {props.data.departmentUserVOList &&
                  <div>
                    <div className="drop-down__item__title">
                        员工 
                    </div>
                    <div className="drop-down__item__con">
                      <div>
                        {props.data.departmentUserVOList.map((item,index)=>{
                          return  <div>
                            <Checkbox onChange={(e)=>{selectuser(e,item)}} >
                                <div className="drop-down__item__con__item">
                                  <div className="drop-down__item__con__item__left">
                                    <WWOpenDataCom type="userName" openid={item.userName}/>
                                  </div>
                                  <div className="drop-down__item__con__item__right">
                                    {item.depNamesList.map((_item,index)=>{
                                      return <span> <WWOpenDataCom type="departmentName" openid={_item}/>{index<(item.depNamesList.length -1)?';':''}</span>
                                      })
                                    }
                                  </div>
                                </div>
                          </Checkbox>
                          </div>
                        })
                        }
                      </div>
                    </div>
                  </div>
                }
                {props.data.departmentVOList &&
                  <div>
                    <div className="drop-down__item__title">
                        部门
                    </div>
                    <div className="drop-down__item__con">
                      <div>
                        {props.data.departmentVOList.map((item,index)=>{    
                          return  <div><Checkbox onChange={(e)=>{selectDep(e,item)}}>
                                      <div className="drop-down__item__con__item">
                                      <div className="drop-down__item__con__item__left">
                                      <WWOpenDataCom type="departmentName" openid={item.name}/>
                                      </div>
                                    </div>
                                </Checkbox>
                            </div>
                        })
                        }
                      </div>
                    </div>
                  </div>
                }
                {(!props.data.departmentUserVOList && !props.data.departmentVOList)&&
                  <div>暂无数据</div>
                }
              </div>
        </div>
        }
    </div>
  );
}

export default withRouter(SearchUser);
