import React, { useContext, useEffect, useState } from 'react'
import './Main.less';
import { Modal } from 'antd';
import { MainRoutes, RedirectRoutes } from '@/routes';
import routeHook from '@/core/routeHook'
import Bus from '@/core//bus';

function Main(props) {
  const { menuType } = props;
  console.log("menuType", menuType);

  useEffect(() => {
    Bus.bind('showRouteChangeModal',showModal )
    return ()=>{
      Bus.unbind('showRouteChangeModal',showModal)
    }
  }, [])

  function showModal(){
    Modal.confirm({
      title: '确定要返回吗？',
      content: '返回后，本次编辑的内容将不被保存',
      okText: '确认返回',
      cancelText: '留在本页',
      icon: <span className='icon iconfont default-confirm-icon'>&#xe6f4;</span>,
      onOk: () => {
        routeHook.leave()
      },
    
    });
  }


  return (
    <div
      className={menuType ? `right-container has-nav` : `right-container has-nav right-container-vertical`}
      id="rightContainer"
    >
      <MainRoutes />
      <RedirectRoutes />
    </div>
  )
}
export default Main;
