import React from 'react';
import { Modal } from 'antd';
import moment from 'moment';
import $ from 'jquery';
import Service from "@/common/js/service";
import './PreviewOfflineModal.less';
import ENUM from '@/modules/knowledge-base/ENUM';

const defaultCoverUrl = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';

class PreviewOfflineModal extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
    }
  }

  componentDidMount() {
    const { data } = this.props;
    _.isEmpty(data) ? this.getCourseDetail() : this.setState({ ...data });
  }

  getCourseDetail = () => {
    Service.Hades('public/hades/getOfflineCourseDetail', {
      courseId: this.props.courseId,
    }).then((res) => {
      if (res.success) {
        const { result } = res;
        let coverUrl = '';
        result.courseMediaVOS.map((item) => {
          switch (item.contentType){
            case "COVER":
              coverUrl = item.mediaUrl;
            break;
            case "INTRO":
              this.getTextDetail('introduce', item.mediaUrl);
              break;  
            default:
              break;
          }
          return item;
        })
        this.setState({
          ...result,
          coverUrl,
        })
      }
    })
  }

  getTextDetail = (key, url) => {
    $.ajax({
      data: {},
      type: 'GET',
      url,
      contentType:'application/x-www-form-urlencoded; charset=UTF-8',
      success: (res) => {
        this.setState({ [key]: res, [`load${key}`]: true });
      }
    })
  }

  render() {
    const {
      coverUrl,
      courseName,
      teacherName,
      courseState,
      categoryName,
      introduce,
      startTime,
      endTime,
      offlinePlace,
      whetherSetApply,
      startTimeApply,
      endTimeApply,
      whetherSetSignIn,
      whetherSetSignOut,
      signInType,
      signOutType,
      signInTimeNum,
      signInTimeUnit,
      signOutStartTimeNum,
      signOutStartTimeUnit,
      signOutEndTimeNum,
      signOutEndTimeUnit,
    } = this.state;
    const unit = (signInTimeUnit || '').toLocaleLowerCase() + 's';
    const time = moment(signInType == 'START_AGO' ? startTime : endTime).subtract(signInTimeNum, unit);
    const signInTime = `${moment(time).format('HH:mm')} ~ ${moment(signInType == 'START_AGO' ? startTime : endTime).format('HH:mm')}`;
    const endUnit = (signOutEndTimeUnit || '').toLocaleLowerCase() + 's';
    const end = moment(endTime).add(signOutEndTimeNum, endUnit);
    let startUnit = '';
    let start = '';
    if (signOutType === 'START_LATER') {
      startUnit = (signOutStartTimeUnit || '').toLocaleLowerCase() + 's';
      start = moment(startTime).add(signOutStartTimeNum, startUnit);
    }
    const signOutTime = signOutType === 'START_LATER' ? `${moment(start).format('HH:mm')} ~ ${moment(end).format('HH:mm')}` : `${moment(endTime).format('HH:mm')} ~ ${moment(end).format('HH:mm')}`;
    return (
      <Modal
        title="预览"
        visible={true}
        width={680}
        onCancel={this.props.close}
        footer={null}
        maskClosable={false}
        closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
        className="preview-live-graphics-modal"
      >
        <div className="container__wrap">
          <div className="container">
            <div className="container__header">
              <div className="cover"></div>
              <img src={coverUrl || defaultCoverUrl} className="course-cover" />
              <span className="cover-teacher">主讲人：{teacherName}</span>
              <span className="cover-state" style={{ background: (ENUM.offlineStateShow[courseState] || {}).color }}>{(ENUM.offlineStateShow[courseState] || {}).title}</span>
            </div>
            <div className="container__body">
              <div className="title__name">{courseName}</div>
              <div className="title__categery">
                <img className="item-icon" src="https://image.xiaomaiketang.com/xm/cDMwz3jzaX.png" />
                课程分类：{categoryName}
              </div>
              <div className="title__categery">
                <img className="item-icon" src="https://image.xiaomaiketang.com/xm/BfTBK3dGda.png" />
                上课时间：{startTime ? moment(startTime).format('HH:mm') : ''}~{endTime ? moment(endTime).format('HH:mm') : ''}
              </div>
              <div className="title__categery">
                <img className="item-icon" src="https://image.xiaomaiketang.com/xm/KhFNBTtAKR.png" />
                上课地点：{offlinePlace}
              </div>
            </div> 
            
            <div className="container__introduction">
              <div className="title">线下课简介</div>
              <div className="container__introduction__list editor-box">
                {whetherSetApply === 'YES' && <div className="course-time">
                  <div className="time-title">报名时间</div>
                  <div className="time-text">{moment(startTimeApply).format('MM-DD HH:mm')} ~ {moment(endTimeApply).format('MM-DD HH:mm')}</div>
                </div>}
                {(whetherSetSignIn === 'YES' || whetherSetSignOut === 'YES') && <div className="course-time">
                  <div className="time-title">考勤时间</div>
                  {whetherSetSignIn === 'YES' &&
                    <div className="time-text">
                      签到：{signInTime}
                    </div>
                  }
                  {whetherSetSignOut === 'YES' &&
                    <div className="time-text">
                      签退：{signOutTime}
                    </div>
                  }
                </div>}
                <div
                  className="intro-item text"
                  dangerouslySetInnerHTML={{
                    __html: introduce
                  }}
                />
              </div>
            </div>
          </div>
        </div>
      </Modal>
    )
  }
}

export default PreviewOfflineModal;
