/*
 * @Author: 吴文洁
 * @Date: 2019-09-10 18:26:03
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-07 19:36:43
 * @Description:
 */
import React , { useContext, useEffect ,useState}from 'react';
import './Header.less';
import {
  Menu,
  Dropdown,
  Modal
} from 'antd';
import { QuestionCircleOutlined } from "@ant-design/icons";
import { withRouter } from 'react-router-dom';

import Bus from '@/core/bus';
import User from '@/common/js/user';
import BaseService from "@/domains/basic-domain/baseService";
import { XMContext } from '@/store/context';
import baseImg from '@/common/images/xiaomai-IMG.png';
const { confirm } = Modal;
function Header(){
  const [menuType, setMenuType] = useState(1);
  const ctx: any = useContext(XMContext);
  function userMenu() {
    return (
      <Menu
        style={{
          maxWidth: "250px",
          marginTop: 5,
        }}
       
      >
        <Menu.Item
          style={{whiteSpace: "normal", wordBreak: "break-all"}}
          key="1"
          onClick={() => toPersonalInfoPage()}
        >
          个人设置
        </Menu.Item>
        <Menu.Item
          style={{whiteSpace: "normal", wordBreak: "break-all"}}
          key="2"
          onClick={e => {
            handleLogoutConfirm();
          }}
        >
          退出登录
        </Menu.Item>
      </Menu>
    );
  }
  function handleMenu(){
 
  };
  function toPersonalInfoPage(){
    window.RCHistory.push({
      pathname: `/personal-info`,
    })
  }
  function handleLogoutConfirm(){
    return confirm({
      title: "你确定要退出登录吗？",
      content: "退出后，需重新登录",
      icon: <QuestionCircleOutlined />,
      okText: "退出登录",
      okType: "danger",
      cancelText: "点错了",
      onOk: () => {
        handleLogout();
      },
    });
  }
  function handleLogout(){

    BaseService.logout({}).then((res) => {
      User.removeUserId();
      User.removeToken();
      window.RCHistory.push({
        pathname: `/login`,
      })
    });

  }
  return (
    <div id="top-container" className="top-container">
      <div className="top top-nav">
        <div>
          {menuType ? (
            <img src="https://image.xiaomaiketang.com/xm/TP2x7aQ24y.png" className="logo" alt="" />
          ):(
            <img src="https://dev.xiaomai5.com/admin/static/images/logo.928339cd.png" className="logo" alt="" />
          )}
        </div>
        {menuType ? (
          <span className="icon iconfont cursor ml20  handLike" onClick={handleMenu}>
            &#xe83d;{' '}
          </span>
          
        ) : (
          <span className="icon iconfont cursor ml20  handLike" onClick={handleMenu}>
            &#xe615;
          </span>
        )}
        <div className="message-help">
        <Dropdown overlay={userMenu()}>
            <div className="user">
              <img
                style={{
                  width: 32 + "px",
                  height: 32 + "px",
                  borderRadius: "50%",
                  overflow: "hidden",
                  flexShrink: 0,
                }}
               
                src={(ctx.xmState && ctx.xmState.storeList &&ctx.xmState.storeList[0].avatar) ? ctx.xmState.storeList[0].avatar:baseImg}
              />
                { ctx.xmState && ctx.xmState.storeList && (
                  <span className="name">{ctx.xmState.storeList[0].nickName}</span>
                  )
                }
            </div>
          </Dropdown>
        </div>
      </div>
    </div>
  );
}
export default withRouter(Header);
