/*
 * @Author: zhangleyuan
 * @Date: 2021-02-20 16:13:39
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-02-21 17:26:00
 * @Description: 描述一下
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from "react";
import PlanFilter from './components/PlanFilter';
import PlanOpt from './components/PlanOpt';
import PlanList from './components/PlanList';
import PlanService from "@/domains/plan-domain/planService";
function PlanPage() {

  const [planListData, setPlanListData] = useState([
    {
      name:'计划名称'
    },
    {
      name:'计划名称'
    }
  ]);
  const [query,setQuery] = useState({
    current:1,
    size:10
  });
  const [totalCount,setTotalCount] = useState(0)
  function handleFetchPlanList(_query){
    const params = {
      ...query,
      ..._query,
    };

    setQuery(params);
    console.log(params);
    //动态获取计划列表
    PlanService.getTrainingPlanPage(params).then((res) => {
      const { result: { records = [], total } } = res;
      setPlanListData(records);
      setTotalCount(total);
    })
  }
  return (
      <div className="page">
        <div className="content-header">培训计划</div>
        <div className="box">
          <PlanFilter onChange={handleFetchPlanList}/>
          <PlanOpt/>
          <PlanList 
            planListData={planListData}
            query={query}
            totalCount={totalCount}
            onChange={handleFetchPlanList}
          />
        </div>
      </div>
  )

}
export default PlanPage;