import React from 'react';
import { withRouter } from "react-router-dom";
import { Table,  Button, Modal, message } from 'antd';
import dealTimeDuration from "../../course-manage/utils/dealTimeDuration";
import { PageControl } from "@/components";
// import './DataList.less';
import KnowledgeAPI from "@/data-source/knowledge/request-api";
import User from '@/common/js/user';

const liveTypeMap = {
  USER: "普通用户",
  ANCHOR: "讲师",
  ADMIN: "管理员（助教）",
  GUEST: "游客"
};
class PlaybackData extends React.Component {
  constructor(props) {
    super(props);
    const id = getParameterByName("id"); // 课程ID

    this.state = {
      playbackData: [],
      current: 1,
      size: 10,
      total: 0,
      id: id,
      storeId: User.getStoreId()
    }
  }

  componentDidMount() {
    this.fetchPlaybackList();
  }

  fetchPlaybackList = (page = 1) => {
    const { size, id } = this.state
    const params = {
      id,
      current: page,
      size
    }

    KnowledgeAPI.queryPageKnowledgeReplayRecordPage(params).then((res) => {
      if (res.result) {
        const { records = [], current, size, total } = res.result;
        this.setState({
          playbackData: records,
          current,
          size,
          total
        });
      }
    });

  };
  getPlaybackColumns() {
    const columns = [
      {
        title: "观看用户",
        dataIndex: "userName",
      },
      {
        title: "手机号",
        dataIndex: "phone"
      },
      {
        title: "观看者类型",
        dataIndex: "userRole",
        render: (text) => <span>{liveTypeMap[text]}</span>,
      },
      {
        title: "开始观看时间",
        dataIndex: "entryTime",
        render: (text) => (
          <span>{text ? formatDate("YYYY-MM-DD H:i", parseInt(text)) : '-'}</span>
        ),
      },

      {
        title: "观看时长",
        dataIndex: "lookingDuration",
        render: (text) => {
          return <span>{text ? dealTimeDuration(text) : '-'}</span>;
        },
      },
    ];
    return columns;
  }
  // 导出
  handleplaybackExport() {
    const { storeId, id } = this.state;

    KnowledgeAPI.exportLiveLearnSync({
      knowledgeId: id,
      exportLiveType: "PLAY_BACK",
      storeId
    }).then((res) => {
      const link = res.result;
      this.setState({
        link
      });
      document.getElementById("load-play-back-excel").click();

      if(res.success){
        message.success("导出成功！")
      }
    })
  }

  onShowSizeChange = (current, size) => {
    if (current == size) {
      return;
    }
    this.setState({ size }, this.fetchUserData)
  }

  render() {
    const { playbackData, total, current, size, link} = this.state
    return (
      <div>
        <a
          href={link}
          target="_blank"
          download
          id="load-play-back-excel"
          style={{ position: "absolute", left: "-10000px" }}
        >
          111
        </a>
        <Button onClick={() => {this.handleplaybackExport()}}>导出</Button>
        <Table
          bordered
          size="small"
          columns={this.getPlaybackColumns()}
          dataSource={playbackData}
          pagination={false}
          style={{ margin: '16px 0' }}>
        </Table>
        { total > 0 &&
        <PageControl
          size="small"
          current={current - 1}
          pageSize={size}
          total={total}
          onShowSizeChange={this.onShowSizeChange}
          toPage={(page) => {
            this.fetchPlaybackList(page + 1);
          }}
        />
        }
      </div>
    )
  }
}

export default withRouter(PlaybackData);