import React from 'react';
import { Row, Input, Select,Tooltip } from 'antd';

import RangePicker from "@/modules/common/DateRangePicker";

import './OfflineCourseFilter.less';
import moment from 'moment';
import StoreService from "@/domains/store-domain/storeService";

const { Search } = Input;
const { Option } = Select;

const DEFAULT_QUERY = {
  courseName: null,   // 课程名称
  operatorId: null,     // 创建人
  beginTime: null,    // 开始日期
  endTime: null,      // 结束日期
  shelfState:null,
}
const defaultTeacherQuery = {
  size: 10,
  current: 1,
  nickName:null
}
class OfflineCourseFilter extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      query: { ...DEFAULT_QUERY },  // 使用扩展运算符,避免浅拷贝
      teacherQuery: defaultTeacherQuery,
      teacherList:[],
      expandFilter:false
    }
  }
  
  componentDidMount() {
    this.getTeacherList();
  }

  getTeacherList(current = 1, selectList){
    const { teacherQuery,teacherList} = this.state;
    const _query = {
      ...teacherQuery,
      current,
      size:10
    };
    StoreService.getStoreUserBasicPage( _query).then((res) => {
        const { result = {} } = res;
        const { records = [], total = 0, hasNext } = result;
        const list = current > 1 ? teacherList.concat(records) : records;
        this.setState({
          hasNext,
          teacherList: list,
        })
    });
  }

  // 滑动加载更多讲师列表
  handleScrollTeacherList = (e) => {
    const { hasNext } = this.state;
    const container = e.target;
    const scrollToBottom = container &&  container.scrollHeight <= container.clientHeight + container.scrollTop;
    if (scrollToBottom && hasNext) {
      const { teacherQuery } = this.state;
      let _teacherQuery = teacherQuery;
      _teacherQuery.current = _teacherQuery.current + 1
      this.setState({
        teacherQuery:{..._teacherQuery}
      },()=>{this.getTeacherList(_teacherQuery.current)})
    }
  }
  // 改变搜索条件
  handleChangeQuery = (field, value) =>  {
    this.setState({
      query: {
        ...this.state.query,
        [field]: value,
        current: 1,
      }
    }, () => {
      if (field === 'courseName') return;
      this.props.onChange(this.state.query)
    });
  }

  handleChangeDates = (dates) => {
    const query = _.clone(this.state.query);
    if (_.isEmpty(dates)) {
      delete query.beginTime;
      delete query.endTime;
    } else {
      query.beginTime = dates[0].valueOf();
      query.endTime = dates[1].valueOf();
    }
    this.setState({
      query:{
        ...query,
        current: 1,
      }
    }, () => {
      this.props.onChange(this.state.query);
    })
  }

  // 重置搜索条件
  handleReset = () => {
    this.setState({
      query: DEFAULT_QUERY,
    }, () => {
      this.props.onChange(this.state.query);
    })
  }

  render() {
    const {
      query: {
        courseName,
        courseState,
        shelfState,
      },
      expandFilter,
    } = this.state;
    
    return (
      <div className="video-course-filter">
        <Row type="flex" justify="space-between" align="top">
          <div className="search-condition">
            <div className="search-condition__item">
              <span className="search-name">线下课名称：</span>
              <Search
                value={courseName}
                placeholder="搜索线下课名称"
                onChange={(e) => { this.handleChangeQuery('courseName', e.target.value)}}
                onSearch={ () => { this.props.onChange(this.state.query) } }
                style={{ width: "calc(100% - 84px)" }}
                enterButton={<span className="icon iconfont">&#xe832;</span>}
              />
            </div>
            <div className="search-condition__item">
              <span className="select-status">课程状态：</span>
              <Select
                style={{ width: "calc(100% - 70px)" }}
                placeholder="请选择"
                allowClear={true}
                value={courseState}
                onChange={(value) => { this.handleChangeQuery('courseState', value) }}
                suffixIcon={<span className="icon iconfont" style={{fontSize:'12px',color:'#BFBFBF'}}>&#xe835;</span>}
              >
                <Option value="UN_START">未开始</Option>
                <Option value="STARTING">进行中</Option>
                <Option value="FINISH">已结束</Option>
                <Option value="EXPIRED">已取消</Option>
              </Select>
            </div>
            <div className="search-condition__item">
              <span className="shelf-status">学院展示：</span>
              <Select
                style={{ width: "calc(100% - 84px)" }}
                placeholder="请选择"
                allowClear={true}
                value={shelfState}
                onChange={(value) => { this.handleChangeQuery('shelfState', value) }}
                suffixIcon={<span className="icon iconfont" style={{fontSize:'12px',color:'#BFBFBF'}}>&#xe835;</span>}
              >
                <Option value="YES">开启</Option>
                <Option value="NO">关闭</Option>
              </Select>
            </div>
          </div>
          <div className="reset-fold-area">
            <Tooltip title="清空筛选"><span className="resetBtn iconfont icon" onClick={this.handleReset}>&#xe61b; </span></Tooltip>
         </div>
        </Row>
      </div>
    )
  }
}

export default OfflineCourseFilter;
