/*
 * @Author: yuananting
 * @Date: 2021-07-28 14:56:52
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-29 09:42:01
 * @Description: 描述一下咯
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useState, useEffect } from "react";
import { Tabs, Tooltip, Switch, Dropdown } from "antd";
import "./TrainList.less";
import { XMTable, PageControl } from "@/components";
import User from "@/common/js/user";

const { TabPane } = Tabs;

function renderMoreOperate(item) {
  return (
    <div className="live-course-more-menu">
      <div className="operate__item">编辑</div>
      <div className="operate__item">分享</div>
      <div className="operate__item">审批作业</div>
      <div className="operate__item">删除 </div>
    </div>
  );
}

function parseColumns() {
  const columns = [
    {
      title: "培训任务",
      key: "planName",
      dataIndex: "planName",
      width: "18%",
      fixed: "left",
      render: (val, record) => {
        return (
          <div className="plan_name_item">
            <img
              className="plan-cover"
              src={
                record.coverUrl ||
                "https://image.xiaomaiketang.com/xm/rEAetaTEh3.png"
              }
              alt=""
            />
            <Choose>
              <When condition={record.planName.length > 25}>
                <Tooltip title={record.planName}>
                  <div className="plan-name">{val}</div>
                </Tooltip>
              </When>
              <Otherwise>
                <div className="plan-name">{val}</div>
              </Otherwise>
            </Choose>
          </div>
        );
      },
    },
    {
      title: "任务状态",
      width: "10%",
      key: "status",
      dataIndex: "status",
      render: (val, record) => {
        return <div className="course-number">{"未开始"}</div>;
      },
    },
    {
      title: "任务数",
      width: "10%",
      key: "courseNum",
      dataIndex: "courseNum",
      render: (val, record) => {
        return <div className="course-number">{val}</div>;
      },
    },
    {
      title: "学习人数",
      width: "10%",
      align: "right",
      key: "cultureCustomerNum",
      dataIndex: "cultureCustomerNum",
      sorter: true,
      render: (val) => {
        return <div className="join-number">{val}</div>;
      },
    },
    {
      title: (
        <span>
          完成率
          <Tooltip title="完成培训任务的人数/学习总人数">
            <i
              className="icon iconfont"
              style={{
                marginLeft: "5px",
                cursor: "pointer",
                color: "#bfbfbf",
                fontSize: "14px",
                fontWeight: "normal",
              }}
            >
              &#xe61d;
            </i>
          </Tooltip>
        </span>
      ),
      width: "10%",
      key: "rate",
      dataIndex: "rate",
      sorter: true,
      render: (val) => {
        return <span>100%</span>
      },
    },
    {
      title: "培训时间",
      width: "12.5%",
      key: "created",
      dataIndex: "created",
      sorter: true,
      render: (val) => {
        return (
          <span style={{ whiteSpace: "nowrap" }}>
            {window.formatDate("YYYY-MM-DD H:i", val)}
          </span>
        );
      },
    },
    {
      title: "创建人",
      key: "createName",
      dataIndex: "createName",
      width: "11%",
      render: (val) => {
        return <div className="create-name">{val}</div>;
      },
    },
    {
      title: "创建时间",
      width: "12.5%",
      key: "created",
      dataIndex: "created",
      sorter: true,
      render: (val) => {
        return (
          <span style={{ whiteSpace: "nowrap" }}>
            {window.formatDate("YYYY-MM-DD H:i", val)}
          </span>
        );
      },
    },
    {
      title: "更新时间",
      width: "10%",
      key: "updated",
      dataIndex: "updated",
      sorter: true,
      render: (val) => {
        return (
          <span style={{ whiteSpace: "nowrap" }}>
            {window.formatDate("YYYY-MM-DD H:i", val)}
          </span>
        );
      },
    },

    {
      title: "操作",
      key: "operate",
      dataIndex: "operate",
      fixed: "right",
      width: "18%",
      render: (val, record) => {
        return (
          <div className="operate">
            <div
              className="operate__item"
              onClick={() => toLearningDataPage(record)}
            >
              数据
            </div>
            {record.enableState === "YES" && (
              <>
                <span className="operate__item split"> | </span>
                <div
                  className="operate__item"
                  onClick={() => {
                    handleShowShareModal(record);
                  }}
                >
                  指派
                </div>
              </>
            )}
            {record.enableState === "YES" && (
              <>
                <span className="operate__item split"> | </span>
                <div
                  className="operate__item"
                  onClick={() => {
                    handleShowShareModal(record);
                  }}
                >
                  发布
                </div>
              </>
            )}
            {(User.getUserRole() === "CloudManager" ||
              User.getUserRole() === "StoreManager") && (
              <>
                <span className="operate__item split"> | </span>
                <Dropdown overlay={renderMoreOperate(record)}>
                  <span className="more-operate">
                    <span className="operate-text">更多</span>
                    <span
                      className="iconfont icon"
                      style={{ color: "#2966FF" }}
                    >
                      &#xe824;
                    </span>
                  </span>
                </Dropdown>
              </>
            )}
          </div>
        );
      },
    },
  ];
  return columns;
}

function TrainList(props) {
  console.log(props.trainListData);
  return (
    <div className="train-list-page">
      <div className="search-box">
        <Tabs type="card">
          <TabPane tab="全部" key="all" />
          <TabPane tab="已发布" key="published" />
          <TabPane tab="未发布" key="unpublished" />
        </Tabs>
      </div>
      <div className="list-content">
        <XMTable
          rowKey={(record) => record.id}
          showSorterTooltip={false}
          dataSource={props.trainListData}
          columns={parseColumns()}
          pagination={false}
          // onChange={handleChangeTable}
          bordered
          size="middle"
          scroll={{ x: 1400 }}
          // className='plan-list-table'
          renderEmpty={{
            description: (
              <span style={{ display: "block", paddingBottom: 24 }}>
                暂无数据
              </span>
            ),
          }}
        />
        {/* <div className='box-footer'>
        <PageControl
          current={props.query.current - 1}
          pageSize={props.query.size}
          total={props.totalCount}
          toPage={(page) => {
            // const _query = { ...props.query, current: page + 1 };
            // props.onChange(_query);
          }}
          // onShowSizeChange={onShowSizeChange}
        /> */}
        {/* </div> */}
      </div>
    </div>
  );
}

export default TrainList;
