/*
 * @Author: yuananting
 * @Date: 2021-06-16 10:14:37
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-18 17:40:48
 * @Description: 描述一下咯
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useState, useRef, useEffect } from 'react';
import { message, Modal } from 'antd';
import { withRouter } from 'react-router-dom';
import PaperContent from '../paper-manage/PaperContent';
import './AddExam.less';

function SelectPaperModal(props: any) {
  const [item, setItem] = useState(props.paperInfo);
  const itemRef = useRef({});

  useEffect(() => {
    itemRef.current = item;
  }, [item]);

  return (
    <Modal
      maskClosable={false}
      width={1080}
      title='选择试卷'
      visible={true}
      centered={true}
      onOk={() => {
        if (Object.keys(itemRef.current).length < 2) {
          // 培训任务中试卷对象默认长度为0，考试中试卷对象默认长度为1
          return message.warning('请选择试卷');
        }
        props.onSelect(itemRef.current);
        props.close();
      }}
      onCancel={() => {
        props.close();
      }}>
      <PaperContent
        paperId={item.paperId}
        onSelect={(item: any) => {
          setItem(item);
        }}
        type='modal-select'></PaperContent>
    </Modal>
  );
}

export default withRouter(SelectPaperModal);
