/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-14 14:16:15
 * @Description: 员工管理页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";
import { withRouter, Switch, Route } from "react-router-dom";
import _ from "underscore";
import { Tabs } from "antd";
import "./StoreDecorationPage.less";
import StoreH5DecorationTab from "./StoreH5DecorationTab";
import StoreWebDecorationTab from "./StoreWebDecorationTab";

const { TabPane } = Tabs;

declare var window: any;

interface StoreDecoprationProps {
  match: {
    url: string;
  };
}

function StoreDecorationPage(props: StoreDecoprationProps) {
  const [currentTab, setCurrentTab] = useState("h5");
  const { match } = props;

  return (
    <div className="page store-decoration-page">
      <div className="page-content">
        <div className="content-header">店铺装修</div>
        <div className="box">
          <Tabs
            onChange={(key) => {
              setCurrentTab(key);
              // window.RCHistory.push(`${match.url}/store-decoration/${key}`);
            }}
            activeKey={currentTab}
          >
            <TabPane key="h5" tab="H5店铺"></TabPane>

            <TabPane key="web" tab="网页端店铺"></TabPane>
          </Tabs>
          {
            currentTab === 'h5' && <StoreH5DecorationTab/>
          }
          {
            currentTab === 'web' && <StoreWebDecorationTab/>
          }
          
          {/* <Switch>
            <Route
              path="/store-decoration/h5"
              component={StoreH5DecorationTab}
            ></Route>

            <Route
              path="/store-decoration/web"
              component={StoreWebDecorationTab}
            ></Route>
          </Switch> */}
        </div>
      </div>
    </div>
  );
}

export default withRouter(StoreDecorationPage);
