/*
 * @Author: 吴文洁 
 * @Date: 2020-07-14 15:41:30 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-23 13:45:16
 * @Description: 大班直播、互动班课列表的筛选组件
 */

import React from 'react';
import { withRouter } from 'react-router-dom';
import { Row,Col, Input, Select ,Tooltip} from 'antd';
import Bus from '@/core/bus';

import TeacherSearchSelect from "@/modules/common/TeacherSearchSelect";
import RangePicker from "@/modules/common/DateRangePicker";
import moment from 'moment';
import StoreService from "@/domains/store-domain/storeService";
import './LiveCourseFilter.less';

const { Search } = Input;
const { Option } = Select;

const defaultQuery = {
  courseName: null,
  startTime: null,
  teacherId: null,
  courseState: null,
  shelfState:null,
}
const defaultTeacherQuery = {
  size: 10,
  current: 1,
  nickName:null
}
class LiveCourseFilter extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      query: {...defaultQuery},
      teacherQuery: defaultTeacherQuery,
      teacherList:[],
      expandFilter:false
    }
  }
  componentDidMount() {
    this.getTeacherList();
  }
  getTeacherList(current = 1, selectList){
    const { teacherQuery,teacherList} = this.state;
    const _query = {
      ...teacherQuery,
      current,
      size:10
    };
    StoreService.getStoreUserBasicPage( _query).then((res) => {
        const { result = {} } = res;
        const { records = [], total = 0, hasNext } = result;
        const list = current > 1 ? teacherList.concat(records) : records;
        this.setState({
          hasNext,
          teacherList: list,
        })
    });
  }
  // 滑动加载更多讲师列表
  handleScrollTeacherList = (e) => {
    const { hasNext } = this.state;
    const container = e.target;
    const scrollToBottom = container &&  container.scrollHeight <= container.clientHeight + container.scrollTop;
    if (scrollToBottom && hasNext) {
      const { teacherQuery } = this.state;
      this.getTeacherList(teacherQuery.current + 1);
    }
  }
  
  // 改变搜索条件
  handleChangeQuery = (field, value) =>  {
    this.setState({
      query: {
        ...this.state.query,
        [field]: value,
        current: 1,
      }
    }, () => {
      if (field === 'courseName') return;
      this.props.onChange(this.state.query)
    });
  }
  
  handleChangeDates = (dates) => {
    const { query } = this.state;
    if (_.isEmpty(dates)) {
      delete query.startTime;
      delete query.endTime;
    } else {
      query.startTime = dates[0].valueOf();
      query.endTime = dates[1].valueOf();
    }
    this.setState({
      query,
      current: 1,
    }, () => {
      this.props.onChange(this.state.query);
    })
  }
  
  // 选择老师
  handleSelectTeacher = (teacher) => {
    const { name: teacherName, teacherId } = teacher;
    this.setState({
      query: {
        ...this.state.query,
        teacherId,
        teacherName,
        current: 1,
      }
    }, () => {
      this.props.onChange(this.state.query);
    })
  }

  // 清空搜索条件
  handleReset = () => {
    this.setState({
      query: {
        ...this.state.query,
        courseName: null,
        startTime: null,
        endTime: null,
        teacherId: null,
        teacherName: null,
        courseState: undefined,
        current: 1,
      },
    }, () => {
      this.props.onChange(this.state.query);
    })
  }

  render() {
    const {
      courseName, startTime, endTime,
      courseState, teacherName, teacherId,
      shelfState
    } = this.state.query;
    const {expandFilter,teacherList,teacherQuery} = this.state;
    const { teacherId: _teahcerId } = {};
    const isTeacher = !!_teahcerId;    // 判断是否是老师身份

    return (
      <div className="live-course-filter">
        <Row type="flex" justify="space-between" align="top">
       
            <div className="search-condition">
              <div className="search-condition__item">
                <span className="search-name">直播名称：</span>
                <Search
                  value={courseName}
                  placeholder="搜索直播名称"
                  onChange={(e) => { this.handleChangeQuery('courseName', e.target.value)}}
                  onSearch={ () => { this.props.onChange(this.state.query) } }
                  style={{ width: "calc(100% - 70px)" }}
                />
              </div>
              <div className="search-condition__item">
                <span className="search-date">上课日期：</span>
                <RangePicker
                  id="course_date_picker"
                  allowClear={false}
                  value={ startTime ? [moment(startTime), moment(endTime)] : null }
                  format={"YYYY-MM-DD"}
                  onChange={(dates) => { this.handleChangeDates(dates) }}
                  style={{ width: "calc(100% - 70px)" }}
                />
              </div>
              <div className="search-condition__item">
                 <span>讲师：</span>
                  <Select
                    placeholder="请选择讲师"
                    style={{ width: 240, marginTop: 6 }}
                    showSearch
                    allowClear
                    filterOption={(input, option) => option}
                    onPopupScroll={this.handleScrollTeacherList}
                    value={teacherId}
                    onChange={(value) => {
                      this.handleChangeQuery('teacherId', value) 
                    }}
                    onSearch={(value) => {
                      teacherQuery.nickName = value
                      this.setState({
                        teacherQuery
                      }, () => {
                        this.getTeacherList()
                      })
                    }}
                  >
                    {_.map(teacherList, (item, index) => {
                      return (
                        <Select.Option value={item.userId} key={item.userId}>{item.nickName}</Select.Option>
                      );
                    })}
                  </Select>
              </div>
              
              { expandFilter &&
                <div className="search-condition__item">
                  <span className="select-status">上课状态：</span>
                  <Select
                    style={{ width: "calc(100% - 70px)" }}
                    placeholder="请选择"
                    allowClear={true}
                    value={courseState}
                    onChange={(value) => { this.handleChangeQuery('courseState', value) }}
                  >
                    <Option value="UN_START">待上课</Option>
                    <Option value="STARTING">上课中</Option>
                    <Option value="FINISH">已完成</Option>
                    <Option value="EXPIRED">未成功开课</Option>
                  </Select>
                </div>
              }
              { expandFilter &&
                <div className="search-condition__item">
                  <span className="shelf-status">上架状态：</span>
                  <Select
                    style={{ width: "calc(100% - 70px)" }}
                    placeholder="请选择"
                    allowClear={true}
                    value={shelfState}
                    onChange={(value) => { this.handleChangeQuery('shelfState', value) }}
                  >
                    <Option value="YES">上架中</Option>
                    <Option value="NO">未上架</Option>
                  </Select>
                </div>
              }
            </div>  

          <div className="reset-fold-area">
            <Tooltip title="清空筛选"><span className="resetBtn iconfont icon" onClick={this.handleReset}>&#xe61b; </span></Tooltip>
            <span style={{ cursor: 'pointer' }} className="fold-btn" onClick={() => {
              this.setState({expandFilter:!expandFilter});
            }}>{this.state.expandFilter ? <span><span>收起</span><span className="iconfont icon fold-icon" >&#xe82d; </span> </span> : <span>展开<span className="iconfont icon fold-icon" >&#xe835; </span></span>}</span>
         </div>
        </Row>
      </div>
    )
  }
}

export default withRouter(LiveCourseFilter);