/*
 * @Author: 吴文洁 
 * @Date: 2020-06-16 11:41:43 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-06 17:33:47
 * @Description: 文件超出大小的限制
 */

import React from 'react';
import { Modal } from 'antd';

import { DEFAULT_SIZE_UNIT } from "@/common/constants/academic/lessonEnum";

import './NonCompliantFileModal.less';

class NonCompliantFileModal extends React.Component {

  constructor(props) {
    super(props);
    this.state = {}
  }

  render() {
    const { isOpen, fileList } = this.props;
    return (
      <Modal
        title="文件超出可上传的大小限制"
        visible={isOpen}
        okText="继续上传"
        cancelText="放弃上传"
        maskClosable={false}
        closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
        onCancel={this.props.onClose}
        onOk={this.props.onOk}
        className="prepare-lesson__non-compliant-file-modal"
      >
        <div className="file-list">
          <div className="file-list__title">以下文件已超出上传限制，无法上传。</div>
          <div className="file-list__content">
            {
              fileList.map((file, index) => {
                let _size = `${(file.size / DEFAULT_SIZE_UNIT).toFixed(1)}M`;
                if (file.size < 0.1 * DEFAULT_SIZE_UNIT) {
                  _size = `${(file.size / 1024).toFixed(1)}kb`;
                }
                return (
                  <div className="file-list__item" key={`file-list__item${index}`}>
                    <span className="file-name">{file.name}</span>
                    <span className="file-size">（{_size}）</span>
                  </div>
                )
              })
            }
          </div>
        </div>
         <div className="tips">
          <span className="icon iconfont">&#xe6f2;</span>
          <span className="tips__text">
          支持上传：Word(100M以内)、Excel(10M以内)、PPT(100M以内)、PDF(100M以内)、图片(5M以内)、音频(20M以内)、视频(500M以内)
          </span>
        </div>
      </Modal>
    )
  }
}

export default NonCompliantFileModal;
