/*
 * @Author: wufan
 * @Date: 2020-04-28 18:05:30
 * @LastEditors: wufan
 * @LastEditTime: 2021-07-05 10:36:15
 * @Description: 线上课课程课节详情
 */

import React,{useEffect, useState} from 'react';
import Breadcrumbs from "@/components/Breadcrumbs";
import { withRouter } from "react-router-dom";
import CourseService from '@/domains/course-domain/CourseService'
import underscore  from 'underscore';
import ScanFileModal from '@/modules/resource-disk/modal/ScanFileModal.jsx';
import './VideoCourseDetail.less';

declare var getParameterByName: any;
declare var window: any;


function VideoCourseDetail(){
    const courseId =  window.getParameterByName("courseId"); // 课程ID
    const [coverUrl,setCoverUrl] = useState("");
    const [videoName,setVideoName] = useState("");
    const [scheduleVideoUrl,setScheduleVideoUrl] = useState("");
    const [courseChapterList,setCourseChapterList] = useState<Array<Object>>([]);
    const [courseName,setCourseName] = useState("");
    const [categoryName,setCategoryName] = useState("");
    const [scanFileModal,setScanFileModal] = useState<any>(null);

    useEffect(()=>{
        handleFetchScheudleDetail(courseId);
    },[courseId])


      // 获取线上课详情
    function  handleFetchScheudleDetail(courseId: string){
    CourseService.videoScheduleDetail({
      courseId
    }).then((res) => {
      const { result = {} } = res || {}
      const { courseName, courseMediaVOS, categoryName, courseChapterVOList =[] } = result
      let coverId:string = "";
      let coverUrl: string = "";
      let videoType: string = "";
      let videoDuration: number = 0;
      let videoName: string = "";
      let scheduleVideoUrl: string = "";

      courseMediaVOS.map((item:any) => {
        switch (item.contentType) {
          case 'COVER':
            coverId = item.mediaContent
            coverUrl = item.mediaUrl
            break
          case 'SCHEDULE':
            videoDuration = item.videoDuration
            videoName = item.mediaName
            scheduleVideoUrl = item.mediaUrl
            videoType = item.mediaType
            break
          default:
            break
        }
        return item
      })

      setCoverUrl(coverUrl);
      setVideoName(videoName);
      setScheduleVideoUrl(scheduleVideoUrl);
      setCourseName(courseName);
      setCategoryName(categoryName);
      setCourseChapterList(courseChapterVOList);
    })
  }

  function handleScanFileModal(fileType: string = "MP4", fileObj: Object){

    const scanFileModal = (
        <ScanFileModal
          fileType={fileType}
          item={fileObj}
          close={() => {
            setScanFileModal(null);
          }}
        />
      );
      setScanFileModal(scanFileModal)
  }


    return <div className="page video-course-detail">
                <Breadcrumbs
                    navList="课程详情"
                    goBack={() => {
                        window.RCHistory.goBack();
                    }}
                />

            <div className="box">
                <div className="course-detail">
                    <div className='course-detail__img'>
                        {/* 如果视频和封面都没有上传的话, 那么就显示缺省, 如果上传了视频, 那么封面图就默认显示视频的第一帧, 如果上传了封面图, 那么就显示上传的封面图 */}
                        <img src={coverUrl || `https://image.xiaomaiketang.com/xm/mt3ZQRxGKB.png`} alt='' />
                    </div>
                    <div className="course-detail__info">
                        <div className="info__title">{courseName}</div>
                        <div className="info__category">{`分类：${categoryName}`}</div>
                        <div className="info__chapterNum">{`课节数量：${courseChapterList.length}`}</div>
                    </div>
                </div>

                <div className="course-chapter">
                    <div className="course-chapter__total">{`共${courseChapterList.length}个课节`}</div>
                    <div className="course-chapter__list">
                        <If condition={courseChapterList.length > 0}>
                            {
                                underscore.map(courseChapterList,(item: any,index: number) => {
                                return <div className='course-ware' onClick={()=>{handleScanFileModal("MP4",item)}} key={index}>
                                        <div className="course-ware__index">{`${index > 9 ? index + 1 : `0${index + 1 }`} `}</div>
                                        <img className='course-ware__img' src='https://image.xiaomaiketang.com/xm/TKwbQGYDBR.png' alt='' />
                                        <div className='course-ware__name'>{item.name}</div>
                                </div>
                                })
                            }
                        </If>
                    </div>
                </div>
            </div>
            {scanFileModal}
    </div>
}

export default withRouter(VideoCourseDetail);