import React, {  useState} from "react";
import { Modal, Button, InputNumber  } from 'antd';
import "./BatchGrade.less"

interface BatchGradeProps {
    visible:boolean,
    onClose: () => void,
}

export default function BatchGrade(props:BatchGradeProps) {

    if (!props.visible) {
        return ("")
    }

    function onOk() {

    }

    function onCancel() {
        props.onClose()
    }

    const inputNumberStyle = {width:"57px",margin:"0 8px"}
    return (
        <Modal 
        className="batchgrade"
        title="批量设置分数"
        onCancel={onCancel}
        onOk={onOk}
        visible={props.visible}
        maskClosable={false}
        width={560}
        >
            <div className="content">
            <div className="item">
                【单选题】
                <span>每题<InputNumber defaultValue={2} style={inputNumberStyle} />分</span>
            </div>
            <div className="item">
                【多选题】
                <span>每题<InputNumber style={inputNumberStyle} />分</span>
            </div>
            <div className="item">
                【不定项选择题】
                <span>每题<InputNumber style={inputNumberStyle} />分</span>
            </div>
            <div className="item">
                【判断题】
                <span>每题<InputNumber style={inputNumberStyle} />分</span>
            </div>
            <div className="item">
                【填空题】
                <span>每题<InputNumber style={inputNumberStyle} />分</span>
            </div>
            </div>

        </Modal>
    )

}