/*
 * @Author: 吴文洁 
 * @Date: 2020-07-15 17:29:12 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-15 18:16:05
 * @Description: 新建/编辑直播课-基本信息
 */

import React from 'react';
import { Input, Button, message ,Cascader } from 'antd';

import UploadOss from "@/core/upload";
import { ImgCutModalNew } from '@/components';

import './AddLiveBasic.less';

const defaultCover = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';

class AddLiveBasic extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      xhr: null,
      imageFile: null,
      showCutModal: false
    }
  }

  // 上传封面图
  handleShowImgCutModal = (event) => {
    const imageFile = event.target.files[0];
    if (!imageFile) return;
    this.setState({
      imageFile,
      showCutModal: true,
    });
  }

  // 使用默认封面图
  handleResetCoverUrl = () => {
    const { data: { coverUrl } } = this.props;
    const isDefaultCover = coverUrl === defaultCover;
    // 如果已经是默认图的话，不做任何任何处理
    if (isDefaultCover) return;
    message.success('已替换为默认图');
    this.props.onChange('coverId', null, defaultCover);
  }

  componentWillUnmount() {
    const { xhr } = this.state;
    xhr && xhr.abort();
  }

  render() {
    const { showCutModal, imageFile } = this.state;
    const { data, liveScene } = this.props;
    const { courseName, coverUrl , courseCatalogOption} = data;
    const fileName = '';
   
    // 当前是否使用的是默认图片
    const isDefaultCover = coverUrl === defaultCover;

    return (
      <div className="add-live__basic-info">
        <div className="course-name">
          <span className="label"><span className="require">*</span>课程名称：</span>
          <Input
            value={courseName}
            placeholder="请输入直播名称(40字以内)"
            maxLength={40}
            style={{ width: 240 }}
            onChange={(e) => { this.props.onChange('courseName', e.target.value)}}
          />
        </div>
        <div className="course-cover">
          <span className="label">封面图：</span>

          <div className="course-cover__wrap">
            
            <div className="img-content">
            {
              isDefaultCover && <span className="tag">默认图</span>
            }
              <img src={coverUrl} />
            </div>
            <div className="opt-btns">
              <input
                type="file"
                value={fileName} // 避免选择同一文件 value不改变 不触发onChange事件
                accept="image/png, image/jpeg, image/bmp, image/jpg"
                ref="stagePicInputFile"
                style={{display: 'none'}}
                onChange={(event) => { this.handleShowImgCutModal(event) }}
              />

              <Button onClick={() => {
                this.setState({
                  currentInputFile: this.refs.stagePicInputFile
                });
                this.refs.stagePicInputFile.click();
              }}>上传图片</Button>
              <span
                className={`default-btn ${isDefaultCover ? 'disabled' : ''}`}
                onClick={this.handleResetCoverUrl}
              >使用默认图</span>
              <div className="tips">建议尺寸690*398像素，图片支持jpg、jpeg、png格式。</div>
            </div>
          </div>
        </div>
        <div className="course-catalog">
          <span className="label"><span className="require">*</span>课程分类：</span>
          <Cascader options={courseCatalogOption}    style={{ width: 240 }} placeholder="请选择课程分类" />
        </div>
        <ImgCutModalNew
          title="裁剪"
          width={550}
          cutWidth={500}
          cutHeight={282}
          cutContentWidth={500}
          cutContentHeight={300}
          visible={showCutModal}
          imageFile={imageFile}
          bizCode='LIVE_COURSE_MEDIA'
          onOk={(urlStr, resourceId) => {
            this.setState({ showCutModal: false });
            this.props.onChange('coverId', resourceId, urlStr);
            this.state.currentInputFile.value = '';
          }}
          onClose={() => this.setState({ showCutModal: false })}
          reUpload={() => { this.state.currentInputFile.click() }}
        />
      </div>
    )
  }
}

export default AddLiveBasic;