import React from 'react';
import {Checkbox} from 'antd';
import './CheckBox.less';

interface CheckBoxProps {
  defaultChecked?: boolean;
  className?: string;
  id?: string;
  name?: string;
  value?: any;
  disabled?: boolean;
  onChange?: (value: any) => void;
  children?: any;
  text?: string;
}

const CheckBox = (props: CheckBoxProps) => {
  const { defaultChecked, className, id, name, value, disabled, onChange, children, text} = props;
  const cls = className || '';
  
  return(
    <Checkbox
        id={id}
        name={name}
        className={cls}
        value={value}
        checked={defaultChecked}
        disabled={disabled}
        onChange={(e: any) => {
        onChange && onChange(e);
      }}>{children ? children : text}</Checkbox>
  );
};

export default CheckBox;
