/*
 * @Author: 吴文洁
 * @Date: 2020-08-20 09:21:40
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-15 11:48:58
 * @Description: 
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */
const DEFAULT_SIZE_UNIT: number = 1000 * 1000; // 将B转换成M

const SUFFIX_MAP: {
  [key: string]: string
} = {
  'doc': 'application/msword',
  'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
  'ppt': 'application/vnd.ms-powerpoint',
  'pptx': 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
  'pdf': 'application/pdf',
  'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
  'xls': 'application/vnd.ms-excel'
}

const FILE_TYPE_ICON_MAP: {
  [key: string]: string
} = {
  word: "https://image.xiaomaiketang.com/xm/Cw44ekhNfR.png",
  DOCX: "https://image.xiaomaiketang.com/xm/Cw44ekhNfR.png",
  DOC: "https://image.xiaomaiketang.com/xm/Cw44ekhNfR.png",
  // 第一期备后端返回的是长的文件类型，备课版改版之后后端返回的是短的文件类型，且大写，所以做个兼容，下面的EXCEl也是一样的
  WORD: "https://image.xiaomaiketang.com/xm/Cw44ekhNfR.png", 
  Excel: "https://image.xiaomaiketang.com/xm/NTFMxcdQnd.png", 
  EXCEL: "https://image.xiaomaiketang.com/xm/NTFMxcdQnd.png", 
  PPT: "https://image.xiaomaiketang.com/xm/cDrBPi5TrH.png",
  PPTX: "https://image.xiaomaiketang.com/xm/cDrBPi5TrH.png",
  PDF: "https://image.xiaomaiketang.com/xm/7TAy7kbTZB.png",
  MP3: "https://image.xiaomaiketang.com/xm/ykjnSWDyQ6.png",
  MP4: "https://image.xiaomaiketang.com/xm/whSYMTdR57.png",
  JPG: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
  PNG: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
  GIF: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
  BMP: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
};

const SUPPORT_FILE_TYPE_MAP: string[] = [
  "application/msword",
  "text/csv",
  "application/vnd.ms-excel",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
  "application/vnd.ms-powerpoint",
  "application/pdf",
  "image/jpeg",
  "image/png",
  "audio/mpeg",
  "audio/mp4",
  "video/mp4",
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "application/vnd.openxmlformats-officedocument.presentationml.presentation",
  "audio/mp3",
  "application/wps-office.pdf",
  "application/wps-office.xls"
];

const LOCAL_FILE_TYPE_MAP: string[] = [
  "application/msword",
  "application/vnd.ms-excel",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
  "application/vnd.ms-powerpoint",
  "application/pdf",
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "application/vnd.openxmlformats-officedocument.presentationml.presentation",
  "application/wps-office.pdf",
  "application/wps-office.xls"
];

const FILR_VERIFY_MAP = {
  "application/msword": {
    type: "word",
    maxSize: 100
  },
  "application/wps-writer": {
    type: "word",
    maxSize: 100,
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
    type: "word",
    maxSize: 100
  },
  "text/csv": {
    type: "Excel",
    maxSize: 10
  },
  "application/vnd.ms-excel": {
    type: "Excel",
    maxSize: 10
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
    type: "Excel",
    maxSize: 10
  },
  "application/wps-office.xls": {
    type: "Excel",
    maxSize: 10
  },
  "application/vnd.ms-powerpoint": {
    type: "PPT",
    maxSize: 100
  },
  "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
    type: "PPT",
    maxSize: 100
  },
  "application/pdf": {
    type: "PDF",
    maxSize: 100
  },
  "application/wps-office.pdf": {
    type: "PDF",
    maxSize: 100
  },
  "image/jpeg": {
    type: "JPG",
    maxSize: 5
  },
  "image/png": {
    type: "JPG",
    maxSize: 5
  },
  "image/jpg": {
    type: "JPG",
    maxSize: 5
  },
  "image/gif": {
    type: "GIF",
    maxSize: 5
  },
  "audio/mpeg": {
    type: "MP3",
    maxSize: 20
  },
  "audio/mp3": {
    type: "MP3",
    maxSize: 20
  },
  "audio/mp4": {
    type: "MP4",
    maxSize: 2000
  },
  "video/mp4": {
    type: "MP4",
    maxSize: 2000
  }
};

const DISK_MAP: {
  [key: string]: string
} = {
  MYSELF: '我的文件',
  COMMON: '公共文件',
  EMPLOYEE: '员工文件'
};

const NON_COMPLIANT_FILE_MAP = {
  'video': {
    accept: 'video/mp4',
    confirm: {
      title: '文件过大，无法上传',
      content: '为保障学员的观看体验，上传的视频大小不能超过100M',
    },
    tooltip: '格式支持mp4，大小不超过100M'
  }
}

// 文件上传
const UPLOAD_REGION = 'oss-cn-hangzhou';
const UPLOAD_PART_SIZE = 1024 * 1024; // 每个分片大小(byte)
const UPLOAD_PARALLEL = 5; // 同时上传的分片数

export {
  DEFAULT_SIZE_UNIT,
  FILE_TYPE_ICON_MAP,
  SUPPORT_FILE_TYPE_MAP,
  LOCAL_FILE_TYPE_MAP,
  FILR_VERIFY_MAP,
  NON_COMPLIANT_FILE_MAP,
  DISK_MAP,
  SUFFIX_MAP,
  UPLOAD_REGION,
  UPLOAD_PART_SIZE,
  UPLOAD_PARALLEL,
}