import React from 'react';
import LiveCourseFilter from './components/LiveCourseFilter';
import LiveCourseOpt from './components/LiveCourseOpt';
import LiveCourseList from './components/LiveCourseList';
import CourseService from "@/domains/course-domain/CourseService";
import User from '@/common/js/user';

class LiveCoursePage extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      courseList: [],    // 直播课列表
      query: {
        current: 1,
        size: 10,
      },
      total: 0,
      loading: true,
    }
  }
  componentWillMount() {
    this.handleFetchLiveList(this.state.query);
  }
  changeShelfState = (index, shelfState) => {
    const { courseList } = this.state;
    courseList[index].shelfState = shelfState;
    this.setState({
      courseList,
    });
  };
  // 获取直播课列表
  handleFetchLiveList = (_query) => {
    const { query } = this.state;
    const params = {
      ...query,
      ..._query,
      storeId: User.getStoreId()
    };
    this.setState({ query: params });
    CourseService.getLiveCloudCoursePage(params).then((res) => {
      const { result: { records = [], total } } = res;
      this.setState({
        total,
        courseList: records
      });
    })
  }
  render() {
    const { query, total, courseList } = this.state;
    return (
      <div className="page big-live-page">
        <div className="content-header">直播课</div>
        <div className="box">
          <LiveCourseFilter
            onChange={this.handleFetchLiveList}
          />
          <LiveCourseOpt />
          <LiveCourseList
            query={query}
            total={total}
            courseList={courseList}
            onChange={this.handleFetchLiveList}
            changeShelfState={this.changeShelfState}
          />
        </div>
      </div>
    )
  }
}

export default LiveCoursePage;