import React from 'react';
import './ChapterList.less';
import { FileTypeIcon } from '@/common/constants/academic/lessonEnum'

const FileTypeIconMap = FileTypeIcon;

function ChapterList(props){
    const { courseChapterList } = props;

    return  <div className='chapter-list-component'>
        <If condition={courseChapterList.length > 0}>
            {
                _.map(courseChapterList,(item,index) => {
                    return <div className='course-ware'>
                        <img className='course-ware__img' src={FileTypeIconMap[item.mediaType]} alt='' />
                        <div className='course-ware__index'>{index < 9 ? `0${index + 1 }` : `${index + 1 }`}</div>
                        <div className="course-ware__detail">
                            <div className='course-ware__detail__name'>{item.mediaName}</div>
                            { item.mediaType === 'VIDEO' &&
                                <div className='course-ware__detail__duration'>{window.formatDuration(item.videoDuration)}</div>
                            }
                        </div>
                    </div>
                })
            }

        </If>
    </div>
}


export default ChapterList;