/*
 * @Description:
 * @Author: zangsuyun
 * @Date: 2021-03-12 11:16:38
 * @LastEditors: zangsuyun
 * @LastEditTime: 2021-04-08 11:51:42
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React from "react";
import { Row, Input, Select, Tooltip } from "antd";

import "./KnowledgeBase.less";
import ENUM from "../ENUM.js";
const { Search } = Input;
const { Option } = Select;

const DEFAULT_QUERY = {
  name: null, // 课程名称
  type: null,
};

class KnowledgeBaseFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      query: { ...DEFAULT_QUERY }, // 使用扩展运算符,避免浅拷贝
    };
  }

  // 改变搜索条件
  handleChangeQuery = (field, value, flag = true) => {
    this.setState(
      {
        query: {
          ...this.state.query,
          [field]: value,
          current: 1,
        },
      },
      () => {
        this.props.onChange(this.state.query,flag);
      }
    );
  };

  // 重置搜索条件
  handleReset = () => {
    this.setState(
      {
        query: DEFAULT_QUERY,
      },
      () => {
        this.props.onChange(this.state.query);
      }
    );
  };

  render() {
    const {
      query: { name, type },
    } = this.state;
    return (
      <div className="knowledge-base-filter">
        <Row type="flex" justify="space-between" align="top">
          <div className="search-condition">
            <div className="search-condition__item">
              <span className="search-name">资料名称：</span>
              <Search
                value={name}
                // allowClear
                placeholder="搜索资料名称"
                onChange={(e) => {
                  this.handleChangeQuery("name", e.target.value, false);
                }}
                onSearch={(value) => {
                  this.handleChangeQuery("name", value);
                }}
                style={{ width: "calc(100% - 84px)" }}
                enterButton={<span className="icon iconfont">&#xe832;</span>}
              />
            </div>
          </div>
          <div className="reset-fold-area">
            <Tooltip title="清空筛选">
              <span
                className="resetBtn iconfont icon"
                onClick={this.handleReset}
              >
                &#xe61b;{" "}
              </span>
            </Tooltip>
          </div>
        </Row>
      </div>
    );
  }
}

export default KnowledgeBaseFilter;
