import React from 'react';
import { Modal } from 'antd';


import './LackConsumeStudentModal.less';

class LackConsumeStudentModal extends React.Component {

  constructor(props) {
    super(props);
    this.state = {

    }
  }



  render() {
    const {onOk, onClose, consumeHourNum, calendarTime, lackConsumeStudentList} = this.props;
    return (
      <Modal
        title="学员剩余课时数不足"
        visible={true}
        okText="继续保存"
        onOk={onOk}
        onCancel={onClose}
        className="lack-consume-student-modal"
      >
        <p className="desc">每位扣课时学员预计消耗<span className="sign">{(consumeHourNum * calendarTime.length).toFixed(1)}</span>课时（此次排课共计<span className="sign">{calendarTime.length}</span>节课，每节课消耗<span className="sign">{consumeHourNum}</span>课时）</p>
        <div className="list-wrap">
          <p>以下学员的剩余课时数不足，请提醒学员及时续费</p>
          <div className="list">
            {lackConsumeStudentList.map(item => {
              return <p>{item.name} {item.phone} 剩余{item.consumeHourNum}课时</p>
            })}
          </div>
          
        </div>
      </Modal>
    )
  }
}

export default LackConsumeStudentModal;
