/*
 * @Author: 吴文洁 
 * @Date: 2020-07-20 17:21:04 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-20 18:19:33
 * @Description: 老师直播说明弹窗
 */

import React from 'react';
import { Modal } from 'antd';

import TeacherTip from './TeacherTip';

import './TeacherLiveModal.less';

class TeacherLiveModal extends React.Component {

   constructor(props) {
    super(props);
    this.state = {
      isXiaomai: false,
    }
  }

  componentWillMount() {
    this.getLivePermission();
  }

  getLivePermission() {
    axios.Apollo("public/businessLive/queryLiveAccount").then((res) => {
      const list = res.result;
      const isXiaomai = _.some(list, (item) => item.channel === "XIAOMAI");
      this.setState({ isXiaomai });
    });
  }


  render() {
    const { isXiaomai } = this.state;
    return (
      <Modal
        title="老师直播说明"
        className="teacher-live-modal"
        visible={true}
        width={740}
        onCancel={this.props.close}
        footer={null}
      >
        <TeacherTip isXiaomai={isXiaomai} />
      </Modal>
    )
  }
}

export default TeacherLiveModal;