/*
 * @Author: 吴文洁
 * @Date: 2020-08-31 09:34:25
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-07-20 17:21:16
 * @Description:
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */

import Storage from './storage';
import { PREFIX, USER_PREFIX } from '@/domains/basic-domain/constants';
declare var window:any;
class User {
  
  getExpirationTime() {
    return Storage.get(`${PREFIX}_expiration_time`)
  }

  getVersion() {
    return Storage.getObj(`${PREFIX}_version`)
  }

  getStoreId(){
    return  window.currentStoreUserInfo.storeId || Storage.get(`${PREFIX}_storeId`)
  }

  getEnterpriseId() {
    return window.currentStoreUserInfo.enterpriseId || Storage.get(`${PREFIX}_enterpriseId`);
  }

  getStoreName() {
    return Storage.get(`${PREFIX}_storeName`);
  }

  getStoreType() {
    return Storage.get(`${PREFIX}_storeType`);
  }

  getStoreUserId() {
    return window.currentStoreUserInfo.storeUserId || Storage.get(`${PREFIX}_storeUserId`);
  }

  getCustomerId() {
    return Storage.get(`${PREFIX}_customerId`);
  }
  
  getUserId() {
    return window.currentStoreUserInfo.userId || Storage.get(`${PREFIX}_userId`);
  }

  getAvatar(){
    return Storage.get(`${PREFIX}_avatar`);
  }
  
  getUserRole() {
    return Storage.get(`${PREFIX}_userRole`);
  }

  getToken() {
    return window.currentStoreUserInfo.token || Storage.get(`${PREFIX}_token`);
  }

  getIsAdmin() {
    return Storage.get(`${PREFIX}_isAdmin`);
  }

  setExpirationTime(value:number) {
    return Storage.set(`${PREFIX}_expiration_time`,value)
  }

  setVersion(value:any) {
    return Storage.setObj(`${PREFIX}_version`,value)
  }

  setStoreId(value:any){
    return Storage.set(`${PREFIX}_storeId`,value)
  }

  setEnterpriseId(value: any) {
    return Storage.set(`${PREFIX}_enterpriseId`, value);
  }

  setStoreName(value: any) {
    return Storage.set(`${PREFIX}_storeName`, value);
  }

  setStoreType(value: any) {
    return Storage.set(`${PREFIX}_storeType`, value);
  }

  setStoreUserId(value: any) {
    return Storage.set(`${PREFIX}_storeUserId`, value);
  }

  setCustomerId(value: any) {
    return Storage.set(`${PREFIX}_customerId`, value);
  }

  setUserId(value: any) {
    return Storage.set(`${PREFIX}_userId`, value);
  }

  setAvatar(value: any) {
    return Storage.set(`${PREFIX}_avatar`, value);
  }

  setUserRole(value: any) {
    return Storage.set(`${PREFIX}_userRole`, value);
  }

  setToken(value: any) {
    return Storage.set(`${PREFIX}_token`, value);
  }

  setIsAdmin(value: any) {
    return Storage.set(`${PREFIX}_isAdmin`, value);
  }

  removeToken() {
    return Storage.remove(`${PREFIX}_token`);
  }

  removeUserId() {
    return Storage.remove(`${PREFIX}_userId`);
  }

  removeEnterpriseId() {
    return Storage.remove(`${PREFIX}_enterpriseId`);
  }

  getCustomerStoreId() {
    return Storage.get(`${PREFIX}_customerStoreId`);
  }
  setCustomerStoreId(value: any) {
    return Storage.set(`${PREFIX}_customerStoreId`, value);
  }
  setIdentifier(value: any) {
    return Storage.set(`${PREFIX}_identifier`, value);
  }
  getIdentifier() {
    return Storage.get(`${PREFIX}_identifier`);
  }
  clearUserInfo() {
    Storage.remove(`${USER_PREFIX}_token`);
    Storage.remove(`${USER_PREFIX}_userId`);
    Storage.remove(`${USER_PREFIX}_userPhone`);
    Storage.remove(`${USER_PREFIX}_bindPhone`);
    Storage.remove(`${USER_PREFIX}_bindWeChat`);
    Storage.remove(`${USER_PREFIX}_userName_${Storage.get(`${USER_PREFIX}_storeId`)}`);
    Storage.remove(`${USER_PREFIX}_avatar_${Storage.get(`${USER_PREFIX}_storeId`)}`);
    Storage.remove(`${USER_PREFIX}_customerId_${Storage.get(`${USER_PREFIX}_storeId`)}`);
  }
}

export default new User();
