/*
 * @Author: yuananting
 * @Date: 2021-03-27 14:55:14
 * @LastEditors: yuananting
 * @LastEditTime: 2021-04-01 14:00:47
 * @Description: 助学工具-试卷主页面
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { Component } from "react";
import "./PaperContent.less"
import CourseCategorySiderTree from "../components/CourseCategorySiderTree";
import PaperList from "./components/PaperList";

class PaperContent extends Component {
    constructor(props) {
        super(props);
        this.state = {};
    }

    getCategoryIdFromSider = (selectedCategoryId) => {
        if (selectedCategoryId && selectedCategoryId.length > 0) {
            this.setState({ selectedCategoryId: selectedCategoryId[0] });
        }
    };

    updatedSiderTreeFromList = (currentTotal, updatedCategoryId) => {
        this.setState({ currentTotal, updatedCategoryId });
    };

    render() {
        return (
            <div className='paper-content-page'>
                <div
                    style={{ borderRight: "0.5px solid #EEEEEE", paddingRight: "4px" }}
                >
                    <div className="sider">
                        <CourseCategorySiderTree
                            type={this.props.type}
                            fromModule="PAPER_INDEX"
                            getSelectedCategoryId={this.getCategoryIdFromSider.bind(this)}
                            currentTotal={this.state.currentTotal}
                            updatedCategoryId={this.state.updatedCategoryId}
                        />
                    </div>
                </div>
                <div className="content">
                    <PaperList
                        paperId={this.props.paperId}
                        onSelect={this.props.onSelect}
                        type={this.props.type}
                        updatedSiderTree={this.updatedSiderTreeFromList.bind(this)}
                        selectedCategoryId={this.state.selectedCategoryId}
                    />
                </div>
            </div>
        );
    }
}

export default PaperContent;
