import User from '@/common/js/user';
import React from 'react';
import Lottie from "lottie-web";
import { Modal } from "antd";
import Service from "@/common/js/service";
import { LIVE_SHARE } from "@/domains/course-domain/constants";
import BaseService from "@/domains/basic-domain/baseService";
import './ErrorCollege.less';

export default class ErrorCollege extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      nickName: '',
    }
  }

  componentDidMount() {
    this.getUserInfo();
    this.getStorePermission();
    var animation = Lottie.loadAnimation({
      path: "https://image.xiaomaiketang.com/xm/AhcJZHdMZf.json",
      name: "test",
      renderer: "svg",
      loop: true,
      autoplay: true,
      container: document.getElementById("lottie-box")
    });
  }

  getStorePermission() {
    const params = {
      storeId: User.getStoreId(),
    };
    Service.Hades('public/customerHades/whetherStopStore', params).then((res) => {
      if (!res.result) {
        window.RCHistory.replace({
          pathname: '/home',
        })
      }
    });
  }
  
  getUserInfo() {
    const param = {
      storeUserId: User.getStoreUserId(),
    };
    BaseService.getStoreUser(param).then((res) => {
      const { nickName } = res.result;
      this.setState({ nickName });
    });
  }
  
  handleLogoutConfirm() {
    return Modal.confirm({
      title: "你确定要退出登录吗？",
      content: "退出后，需重新登录",
      icon: (
        <span className="icon iconfont default-confirm-icon">&#xe839; </span>
      ),
      okText: "退出登录",
      cancelText: "点错了",
      onOk: () => {
        this.handleLogout();
      },
    });
  }

  handleLogout() {
    BaseService.logout({identifier:User.getIdentifier()}).then((res) => {
      User.removeUserId();
      User.removeToken();
      User.removeEnterpriseId();
      window.RCHistory.replace('/login');
      // User.clearUserInfo();
      // const url = `${LIVE_SHARE}store/index?id=${User.getCustomerStoreId()||User.getStoreId()}&userId=${User.getUserId()}&from=work_weixin`;
      // window.location.href = url;

    });
  }

  render() {
    const { nickName } = this.state;
    return (
      <div className="error-college-page">
        <div className="header">
          <img src='https://image.xiaomaiketang.com/xm/FEdG7BMwKr.png' className="logo" alt="" />
          <div className="name-box">
            <img src='https://image.xiaomaiketang.com/xm/hcp6zs5HTn.png' className="avatar" alt="" />
            <span className="name">{nickName}</span>
            <span
              className="control"
              onClick={() => {
                this.handleLogoutConfirm();
              }}
            >退出登录</span>
          </div>
        </div>
        <div className="error-college-box">
          <div id="lottie-box" className="error-college-image"></div>
          <span className="error-college-tip">{User.getStoreName()}已停用</span>
        </div>
      </div>
    )
  }
}