/*
 * @Author: 吴文洁
 * @Date: 2020-08-31 09:34:31
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-09 19:07:53
 * @Description: 
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */
import qs from 'qs';
import axios, { AxiosInstance, AxiosRequestConfig, AxiosResponse, AxiosPromise, AxiosError } from 'axios';
import { message } from 'antd';

import { BASIC_HOST, TIME_OUT, USER_TYPE, VERSION, PROJECT } from '@/domains/basic-domain/constants';

import User from './user';

interface FetchParams {
  url: string,
  data: any,
  options?: FetchOptions
}

interface FetchOptions {
  requestType: string   // 请求类型  form为表单类型   json为json类型，默认json类型
}

class Axios {

  static post(
    method: string,
    url: string,
    params: any,
    options: FetchOptions = { requestType: 'json' }
  ): Promise<any> {
    const _url = `${url}?storeId=${User.getStoreId()}&token=${User.getToken()}&storeUserId=${User.getStoreUserId()}&userId=${User.getUserId()}`;
    // const _url = `${url}?storeId=${User.getStoreId()}&token=${User.getToken()}&storeUserId=${User.getStoreUserId()}&userId=${User.getUserId()}p=w&v=v5.4.8&userType=B&token=9f1609b2e7234afd8922a8676dbbf721&uid=920261769807528000&tid=1305385165390426114&aid=1305385165390426114`;
    return new Promise((resolve, reject) => {

      const instance: AxiosInstance = axios.create({
        timeout: TIME_OUT,
        responseType: 'json',
        headers: {
          storeId: User.getStoreId(),
          storeUserId: User.getStoreUserId(),
          userId: User.getUserId(),
          token: User.getToken(),
          product: "xmCloudClass",
          'Content-Type': options.requestType === 'form' ? 'application/x-www-form-urlencoded' : 'application/json; charset=UTF-8',
        }
        // headers: {
        //   "content-length": "2",
        //   "referer": "https://dev.xiaomai5.com/",
        //   "x-b3-parentspanid": "e5e8fdfc471ed007",
        //   "sec-fetch-site": "same-site",
        //   "origin": "https://dev.xiaomai5.com",
        //   "x-b3-sampled": "1",
        //   "x-forwarded-port": "443",
        //   "project": "xmzj-web-b",
        //   "tid": "1305385165390426114",
        //   "uid": "920261769807528000",
        //   "instid": "1213001850820476929",
        //   "x-forwarded-host": "dev-heimdall.xiaomai5.com",
        //   "host": "dev-heimdall.xiaomai5.com",
        //   "content-type": "application/json; charset=UTF-8",
        //   "x-b3-flags": "0",
        //   "x-request-id": "0d7ad401ed447ff75c0de254563e76fd",
        //   "sec-fetch-mode": "cors",
        //   "x-forwarded-proto": "https",
        //   "accept-language": "zh-CN,zh;q=0.9,en;q=0.8",
        //   "usertype": "B",
        //   "xmversion": "5.0",
        //   "x-forwarded-for": "60.191.55.162",
        //   "accept": "application/json, text/plain, */*",
        //   "token": "9f1609b2e7234afd8922a8676dbbf721",
        //   "x-real-ip": "60.191.55.162",
        //   "p": "w",
        //   "x-b3-traceid": "12a41d862eb3e551",
        //   "x-b3-spanid": "08dc4d59580c4bee",
        //   "v": "VERSION",
        //   "vn": "v5.4.8",
        //   "x-scheme": "https",
        //   "bizaccountid": "1305385165390426114",
        //   "accept-encoding": "gzip, deflate, br",
        //   "user-agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36",
        //   "cid": "940838898156699712",
        //   "sec-fetch-dest": "empty"
        // },
      });
      
      if (method !== 'GET' && options.requestType === 'form') {
        instance.defaults.transformRequest = [(queryParam): string => {
          let ret: string = '';
          const queryKeys = Object.keys(queryParam);
          queryKeys.forEach((item: string, index: number): void => {
            if (index < queryKeys.length - 1) {
              ret += `${encodeURIComponent(item)}=${encodeURIComponent(queryParam[item])}&`;
            } else {
              ret += `${encodeURIComponent(item)}=${encodeURIComponent(queryParam[item])}`;
            }
          });
          ret.replace(/&$/, '');
          return ret;
        }]
      }

      instance.interceptors.request.use((config: AxiosRequestConfig): AxiosRequestConfig => {
        return config;
      }, (error: Error): Promise<any> => {
        return Promise.reject(error);
      })

      instance.interceptors.response.use((response: AxiosResponse): AxiosResponse | AxiosPromise => {
        const { message: ResMessage, success, resultMsg, resultCode } = response.data;
        if (success || resultCode === 0) {
          return response;
        }
        message.error(ResMessage || resultMsg);
        return Promise.reject(response.data);
      }, (error): AxiosPromise => {
        console.log("error222",error)
        // 403退出登录
        if(error.message.indexOf("403")){
          window.RCHistory.replace('/login');
        }
        
        message.error(error.message)
        return Promise.reject(error.message);
      });

      let config: any;
      if (method === 'GET') {
        config = Object.assign({ params, url: `${BASIC_HOST}${_url}`, method });
      } else {
        config = Object.assign({ data: params, url: `${BASIC_HOST}${_url}`, method });
      }

      instance(config).then((res: AxiosResponse): void => {
        resolve(res.data);
      }).catch((error: Error) => {
        reject(error);
      })
    })
  }
}

export default Axios;




