/*
 * @Author: wufan
 * @Date: 2020-11-27 16:21:49
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-08 18:05:52
 * @Description: Description
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useState, useEffect } from "react";
import { Modal,Form,Input,Button,Select,message} from "antd";
import './SecondCatalogAddOrEditModal.less'
import User from '@/common/js/user';
import _ from "underscore";
import StoreService from "@/domains/store-domain/storeService";


const { Option } = Select;
interface SecondCatalogAddOrEditModalProps {
  onClose:any;
  modalType:string;
  parentId:string;
  choosedItem:any;
  refreshCatalogList:any;
}

function SecondCatalogAddOrEditModal(props: SecondCatalogAddOrEditModalProps) {
  const {onClose,modalType,parentId,refreshCatalogList,choosedItem} = props;
  console.log('choosedItem',choosedItem);
  const [secondCatalogName,setSecondCatalogName] =  useState(choosedItem.categoryName);
  const [selectParentId,setSelectParentId] =  useState(parentId);
  const [optionList,setOptionList] = useState([]);
  const [query, setQuery] = useState({
    current: 0,
    size: 100,
    storeId: User.getStoreId(),
  });
  useEffect(() => {
    getOptionList();
  },[query]);
  function getOptionList():any {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getCourseCatalogList(_query).then((res: any) => {
      let resultData = handleCatalogListData(res.result.records)
      setOptionList(resultData);
    });
  }
  function handleCatalogListData(listData:any){
    listData.map((item:any,index:any) => {
      item.type = "parent"
      item.key = item.id;
      if(item.sonCategoryList){
        item.sonCategoryList.map((_item:any,_index:any) =>{
          _item.type = "child";
          _item.key=_item.id
          return _item
        });
      }
      return item
    })
    return listData
  }

  function handleConfirm(){
    if(modalType === "add"){
      addSecondcatalog();
    }else{
      editSecondcatalog();
    }
  }
  function addSecondcatalog():any{
    const param = {
      parentId:selectParentId,
      storeId: User.getStoreId(),
      categoryName:secondCatalogName
    }
    StoreService.addCourseCategory(param).then((res: any) => {
      refreshCatalogList();
      onClose();
      message.success("添加子分类成功");
    });
  }
  function editSecondcatalog():any{
    const param = {
      parentId:selectParentId,
      categoryId:choosedItem.id,
      categoryName: secondCatalogName,
    }
    StoreService.editCourseCategory(param).then((res: any) => {
      refreshCatalogList();
      onClose();
      message.success("编辑子分类成功");
    });
  }
  return (
    <Modal
      visible={true}
      title={modalType === "add" ? '添加子分类' : '编辑子分类' }
      className="second-catalog-add-edit-modal"
      onCancel={onClose}
      width={448}
      footer={[
        <Button
            id='cancel_allot_btn'
            key="back" onClick={onClose}>取消</Button>,
        <Button
            id='confirm_allot_btn'
            key="submit"
            type="primary"
            onClick={() => {
                handleConfirm()
            }}>
            保存
        </Button>
      ]}
      maskClosable={false}
    >
     <Form
        labelCol={ {span:6 }}
     >
        <Form.Item
              label="子分类名称"
              name="子分类名称"
              rules={[{ required: true}]}
          >
          <Input type="text" 
              placeholder="请输入子分类名称，最多10个字"
              maxLength={10}  
              style={{ width: 240 }}  
              defaultValue={secondCatalogName}
              onChange={(e) => { 
                setSecondCatalogName(e.target.value);
              }}  
          />  
        </Form.Item>
        <Form.Item
              label="所属分类"
              name="所属分类"
              rules={[{ required: true}]}
          >
           <Select
                style={{ width: 240 }}
                defaultValue={parentId}
                onChange={(value) => {
                  setSelectParentId(String(value))
                }}
              >
                {_.map(optionList, (item:any, index) => {
                  return <Option id={item.id} value={item.id}>{item.categoryName}</Option>
                })}

              </Select>
        </Form.Item>
     </Form>
    </Modal>
  );
}

export default SecondCatalogAddOrEditModal;
