/*
 * @Author: 陈剑宇
 * @Date: 2020-05-07 14:43:01
 * @LastEditTime: 2021-04-15 21:42:47
 * @LastEditors: yuananting
 * @Description: 
 * @FilePath: /wheat-web-demo/src/domains/basic-domain/constants.ts
 */
import { MapInterface } from '@/domains/basic-domain/interface'

// 默认是 dev 环境
const ENV: string = process.env.DEPLOY_ENV || 'dev';
console.log("process.env.DEPLOY_ENV",process)
const BASIC_HOST_MAP: MapInterface = {
  dev: 'https://dev-heimdall.xiaomai5.com/',
  dev1: 'https://dev1-heimdall.xiaomai5.com/',
  rc: 'https://rc-heimdall.xiaomai5.com/',
  gray: 'https://gray-heimdall.xiaomai5.com/',
  prod: 'https://gateway.xiaomai5.com/'
};
const PATH_MAP: MapInterface = {
  dev: 'https://dev.xiaomai5.com/xiaomai-cloud-class-web/h5.html',
  dev1: 'https://dev.xiaomai5.com/xiaomai-cloud-class-web/h5.html',
  rc: 'https://rc.xiaomai5.com/xiaomai-cloud-class-web/h5.html',
  gray: 'https://gray.xiaomai5.com/xiaomai-cloud-class-web/h5.html',
  prod: 'https://b.xiaomai5.com/xiaomai-cloud-class-web/h5.html'
};

// axios headers config
export const TIME_OUT: number = 20000;
export const USER_TYPE: string = 'B';
export const PROJECT = 'xmzj-web-b';
export const VERSION = '5.4.8';
export const PREFIX = 'cloud-class';
export const USER_PREFIX = 'store-live';

// host
export const BASIC_HOST: string = BASIC_HOST_MAP[ENV];
export const PATH: string = PATH_MAP[ENV];
