/*
 * @Author: 吴文洁 
 * @Date: 2020-05-19 11:01:31 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-05-25 16:50:47
 * @Description 余额异常弹窗
 */
import React from 'react';
import { Modal } from 'antd';
import AccountChargeModal from './AccountChargeModal';
import './AbnormalModal.less';

class AbnormalModal extends React.Component {

  constructor(props) {
    super(props);
    this.state = {};
  }

  handleRecharge = () => {
    const chargeModal = (
      <AccountChargeModal
        close={() => {
          this.setState({
            chargeModal: null,
          });
          this.props.onClose()
        }}
        refresh={() => { window.location.reload(); }}
      />
    );
    this.setState({ chargeModal });
  };

  render() {
    const {
      title, onClose, balance = 0, outDays, hasOwedFee
    } = this.props;
    
    const content = hasOwedFee ? (
      <div className="content">
        你的云课堂账户余额已持续欠费 <span className="high-light">{outDays}</span> 天，请及时充值。持续欠费 <span className="high-light">90</span> 天，系统将自动清除系统数据与回放视频。
      </div>
    ) : (
      <div
        className="content"> 你的小麦云课堂余额不足（<span className="high-light">{balance.toFixed(2)}</span>元），为保障您直播间的正常使用，请您及时充值。余额耗尽后将无法进行直播，学员无法观看回放视频。
      </div>
    );

    return (
      <div className="abnormal-modal-wrapper">
        <Modal
          title={title}
          visible={true}
          footer={null}
          onCancel={onClose}
          className="abnormal-modal"
        >
          { content }
          <div
            className="charge-btn"
            onClick={() => { this.handleRecharge() }}
          >去充值</div>

        </Modal>
        { this.state.chargeModal }
      </div>
    )
  }
}

export default AbnormalModal;