import React from 'react';
import Service from '@/common/js/service';
import { DISK_MAP } from '@/domains/resource-disk/constants';
import FolderManage from './components/FolderManage';
import DiskList from './components/DiskList';
import './index.less';


const defaultRootDisk = {
  folderName: '公共文件',
  disk: 'MYSELF',
  uploadPower: false
}

class PrepareLessonPage extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      diskList: [],                   // 可见磁盘目录
      currentRootDisk: defaultRootDisk
    }
  }

  componentWillMount() {
    this.handleFetchDiskList();
  }

  handleFetchDiskList = async () => {
    const res = await Service.Hades('public/apollo/getUserDisk', {});
    const { result = [] } = res;
    const diskList = result.map((item) => {
      return {
        ...item,
        folderName: DISK_MAP[item.disk]
      }
    });
    this.setState({
      diskList,
      currentRootDisk: diskList[0] || defaultRootDisk
    });
  }

  handleChangeDisk = (disk) => {
    this.setState({
      currentRootDisk: disk
    });
  }

  render() {
    const { currentRootDisk, diskList } = this.state;

    return (
      <div className="prepare-lesson-page page">
        <div className="content-header">资料云盘</div>
        <div className="box content-body">
          <DiskList
            diskList={diskList}
            currentRootDisk={currentRootDisk}
            onChange={this.handleChangeDisk}
          />
          <FolderManage
            currentRootDisk={currentRootDisk}
          />
        </div>
      </div>
    )
  }
}

export default PrepareLessonPage;