import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import {Form,Button,Input} from "antd";
import Breadcrumbs from "@/components/Breadcrumbs";
import UpLoad from "../common/UpLoad";
import _ from 'underscore';
import $ from 'jquery';
import baseImg from '@/common/images/xiaomai-IMG.png';
import {CropperModal} from '@/components/';

import './index.less';
const FormItem = Form.Item;
function PersonalInfoPage() {
  const [avatar,setAvatar]  = useState(baseImg);
  const [imgUrl, setImgUrl] = useState(avatar);
  const [cropperModalVisible, setCropperModalVisible] = useState(false);

  function _handleUpdateAvatar(e: any): any {
    const avatar = e.target.files[0];
    const newUrl = URL.createObjectURL(avatar);
    const $image = $('#image');
    setImgUrl(newUrl);
    setCropperModalVisible(true);
  }

  function _onUpload(): any {
    $('#CrpperAvatarPic').trigger('click');
  }

  function changeAvatar(img:string):any{
    setAvatar(img);
    setImgUrl(img);
  }

  function closeCropperModal():any{
    setCropperModalVisible(false);
  }
  return (
    <div className="page personal-info-page">
      <div className="page-content">
        <div className="content-header"> 
          <Breadcrumbs
            navList="个人设置"
            goBack={() => { 
              window.RCHistory.goBack();
            }}
          />
          </div>
        <div className="box">
        <Form>
          <div className="avatat-item">
            <span className="label">头像：</span>
            <Button id="click_upload_btn" onClick={_onUpload}>点击上传</Button>
            <input
              type="file"
              accept="image/*"
              id="CrpperAvatarPic"
              style={{ display: 'none' }}
              onChange={_handleUpdateAvatar} />
            <img className="avatar" src={avatar}></img>
            { cropperModalVisible &&
              <CropperModal 
                imgUrl={imgUrl}
                save={changeAvatar}
                close={closeCropperModal}
              />
            }
          </div>
          <div className="name-item">
            <span className="label">姓名：</span>
            <Input placeholder="请输入姓名" style={{ width:300,height:32}} />
          </div>
          <div className="phone-item">
            <span className="label">手机号：</span>
            <span>1822692727</span>
            <Button className="changePhoneBtn">更换手机号</Button>
          </div>
          <div>
            <Button type="primary">保存</Button>
          </div>
        </Form>
          {/* <Form>
            <FormItem
              label="个人头像"
              labelCol={{ span: 2 }}
            >
              <div id="avatar_edit" className="img-box" style={{ width: 54, height: 54, display: 'inline-block' }}>
                <UpLoad
                
                />
              </div>
            </FormItem>
            <FormItem
              label="姓名"
              labelCol={{ span: 2 }}
            >
              <span>{window.currentUserInstInfo.adminName}</span>
            </FormItem>
            <FormItem
              label="昵称"
              labelCol={{ span: 2 }}
            >
              <Input
                id="nick_name_input"
                value={this.state.nickName}
                placeholder="昵称不能超过10个字符"
                style={{ width: 200 }}
                onChange={(event) => {
                  let nickName = event.target.value;
                  this.setState({ nickName });
                }} />
              <Row>
                <Col span={2}></Col>
                <Col>
                  <span className="icon iconfont" style={{ color: '#20A1FF', marginRight: 10 }}>&#xe64d;</span>“昵称”将用于家长端中的家校互动展示
                </Col>
              </Row>
            </FormItem>
            <FormItem>
              <Col span={2}></Col>
              <Button
                id="update_user_info_btn"
                onClick={this.handleEditNickName}
                type="primary" >
                更新信息
              </Button>
            </FormItem>
          </Form> */}
        </div>
      </div>
    </div>
  );
}

export default withRouter(PersonalInfoPage);
