import React, { useState, useEffect } from 'react';
import { Modal, Form, Button, Input } from 'antd';
import _ from 'underscore';
import './EmployeeAddOrEditModal.less';

declare let window: any;

interface AddEmployeeModalProps {
    isOpen: boolean,
    choosedItem:{
        name?: string,
        phone?: string,
        role?: string,
        avatar?: string
    }
}

function AddEmployeeModal(props: AddEmployeeModalProps) {
    const [name, setName] = useState("");
    const [phone, setPhone] = useState("");
    const [role, setRole] = useState("");
    const [avatar, setavatar] = useState("");

    useEffect(() => {
        if(props.choosedItem.name){
            setName(name);
            setPhone(phone);
            setRole(role);
            setavatar(avatar)
        }
    }, [props.choosedItem])

    const layout = {
        labelCol: { span: 8 },
        wrapperCol: { span: 16 },
    };

    const onFinish = (values: any) => {
        console.log('Success:', values);
    };

    const onFinishFailed = (errorInfo: any) => {
        console.log('Failed:', errorInfo);
    };

    return (
        <Modal
            visible={props.isOpen}
            footer={null}
            className="employee-add-modal"
        >
            <Form
                {...layout}
                name="basic"
                initialValues={{ remember: true }}
                onFinish={onFinish}
                onFinishFailed={onFinishFailed}
            >
                <Form.Item
                    label="员工姓名"
                    name="name"
                    rules={[{ required: true, message: '' }]}
                >
                    <Input 
                        value={name}
                        placeholder="请输入员工名称"
                        maxLength={15}
                     />
                </Form.Item>

                <Form.Item
                    label="手机号码"
                    name="name"
                    rules={[{ required: true, message: '' }]}
                >
                    <Input 
                        value={phone}
                        placeholder="请输入手机号"
                        maxLength={11}
                     />
                </Form.Item>
            </Form>
        </Modal>
    )
}

export default AddEmployeeModal;