import React from 'react';
import { withRouter } from "react-router-dom";
import { Form, Input, Button, Modal, message} from 'antd';
import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal';
import Upload from '@/core/upload';
import StoreService from "@/domains/store-domain/storeService";
import User from "@/common/js/user";
import Bus from '@/core/tbus';
import ImgClipModal from '@/components/ImgClipModal'
import "./CollegeInfoPage.less";
let cutFlag = false;
class CollegeInfoPage extends React.Component {
  formRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      storeName:null,
      logo:'',
      showSelectFileModal:false,
      cutImageBlob: null,
      imageFile: null, // 需要被截取的图片
    }
  }
  componentWillMount() {
    if (User.getEnterpriseId()) {
      this.getStoreDetail()
    } else {
      window.RCHistory.replace('/store-info')
    }
  }
  getStoreDetail = ()=>{
    const params= {
      storeId:User.getStoreId()
    }
    StoreService.getStoreDetail(params).then((res) => {
      const { result = { } } = res;
      const {
        storeName,
        logo
      } = result;
      this.formRef.current.setFieldsValue({
        storeName:storeName
      });
      this.setState({
        storeName,
        logo
      })
    });
  }
  onChangeFiledValue=(filed,value)=>{
    this.setState({
      [filed]:value
    })
  }
  handleSelectCover = (file)=> {
    // this.uploadImage(file);
    this.setState({
      visible: true,
      imageFile:file
    });
  }
  
  
  //获取resourceId
  getSignature = (blob, fileName) => {
    Upload.uploadBlobToOSS(blob, 'cover' + (new Date()).valueOf(),null,'signInfo').then((signInfo) => {
      this.setState({
        coverClicpPath:signInfo.fileUrl,
        coverId:signInfo.resourceId,
        visible: false
      },()=>this.updateCover())
    
    });
  };
  updateCover = () =>{
    const {coverClicpPath,coverId} = this.state
    this.setState({
      showSelectFileModal: false
    })
    this.setState({
      logo:coverClicpPath
    })
  }

  updateInfo=()=>{
    const { storeName, logo } = this.state;
    if(!storeName){
      message.warning('请输入学院名称');
     return;
    }
    const params= {
      storeName,
      logo,
      storeId:User.getStoreId()
    }
    StoreService.updateStoreMessage(params).then((res) => {
      User.setStoreName(storeName);
      Bus.trigger('storeNameChange',storeName);
      message.success('保存成功');
    });
  }
  render() {
    const {
      storeName,
      showSelectFileModal,
      visible,
      hasImgReady,
      logo,
      cutImageBlob,
      imageFile
    } = this.state;
    return (
      <div className="page college-info-page">
        <div className="content-header">学院基本信息</div>
        <div className="box">
          <div className="college-info-header">学院基本信息</div>
          <div className="college-info-page-form">
           
            <Form ref={this.formRef}>
              <Form.Item
                label="学院LOGO"
              >
                <div className="logo-con">
                  <div className="logo-img-con">
                    { logo ?  <img src={logo}  className="logo-img"/> : <div className="logo-box"><span className="text">Logo</span></div>}
                  </div>
                  <div className="upload-box">
                    <span onClick={() => {this.setState({ showSelectFileModal:true  })}} className="upload-btn">
                      <span>上传</span>
                    </span>
                    <div className="tip">建议尺寸702*180px。最大2M，支持jpg、jpeg和png。</div>
                  </div>  
                </div>
              </Form.Item>
              <Form.Item
                label="学院名称"
                name="storeName"
                rules={[{ required: true}]}
              >
                <Input
                  value={storeName}
                  style={{ width: '300px' }}
                  placeholder="请输入学院名称"
                  onChange={(e) => this.onChangeFiledValue("storeName", e.target.value)}
                  maxLength={30}
                />
              </Form.Item>
          
            </Form>
          </div>
          {showSelectFileModal && 
            <SelectPrepareFileModal
              key="basic"
              operateType="select"
              multiple={false}
              accept="image/jpeg,image/png,image/jpg"
              selectTypeList={['JPG', 'JPEG', 'PNG']}
              tooltip='支持文件类型：jpg、jpeg、png'
              isOpen={showSelectFileModal}
              onClose={() => {
                this.setState({
                  showSelectFileModal:false
                })
              }}
              onSelect={this.handleSelectCover}
            />
          }
        { visible &&
          <ImgClipModal visible={visible} imgUrl={imageFile.ossUrl}  aspectRatio='125/32' cropBoxHeight='128' onConfirm={this.getSignature} onClose={()=>{this.setState({ visible: false });}}/>
        }
          <div><Button type="primary" onClick={this.updateInfo} htmlType="submit" className="submit-btn">更新信息</Button></div>
        </div>

      </div>
    )
  }
}

export default withRouter(CollegeInfoPage);