/*
 * @Author: 吴文洁 
 * @Date: 2019-09-25 18:09:07 
 * @Last Modified by: wufan
 * @Last Modified time: 2020-07-11 13:48:57
 * @Description: 小麦秀相关常量
 */
const isRc = location.host.indexOf('rc') !== -1;
const isDev = location.host.indexOf('localhost') !== -1 || location.host.indexOf('dev.xiaomai5.com') !== -1;
const isGray = location.href.indexOf('gray') !== -1;
const isDev1 = location.href.indexOf('dev1') !== -1;

let host = 'https://dev.xiaomai5.com/show/';
let latestHost = 'https://dev.xiaomai5.com/xmshow/#/';

if (isDev) {
    host = 'https://dev.xiaomai5.com/show/';
    latestHost = 'https://dev.xiaomai5.com/xmshow/#/';
} else if (isDev1) {
    host = 'https://dev1.xiaomai5.com/show/';
    latestHost = 'https://dev1.xiaomai5.com/xmshow/#/';
} else if (isRc) {
    host = 'https://rc.xiaomai5.com/show/';
    latestHost = 'https://rc.xiaomai5.com/xmshow/#/';
} else if (isGray) {
    host = 'https://res.xiaomai5.com/show/';
    latestHost = 'https://res.xiaomai5.com/xmshow/gray/index.html#/';
} else {
    host = 'https://res.xiaomai5.com/show/';
    latestHost = 'https://res.xiaomai5.com/xmshow/index.html#/';
}

export const HOST = host;
export const LATESTHOST = latestHost;

export const IS_DEV = isDev;
export const IS_DEV1 = isDev1;
export const IS_RC = isRc;
export const IS_GRAY = isGray;

export const TEMPLATE_TYPE = {
  'groupType': '团购',
  'lessonType': '微传单',
  'bargainType': '砍价',
  'tyType': '集赞',
  'solitaireType': '群接龙',
  'redPackageType': '微游戏',
  'rollType': '抽奖',
  'voteType': '投票',
  'gachaType':'扭蛋机',
  'distributeType': '分销'
};

export const TAG_TYPE = {
  'holiday': '节假日',
  'spring': '春招',
  'summer': '夏招',
  'autumn': '秋招',
  'winter': '冬招',
  'keepClass': '续班',
  'lesson': '体验课',
  'other': '其他'
};

// 活动参与详情年级常量
export const GRADE = [
  { label: "学前", value: 1004 },
  { label: "小班", value: 1001 },
  { label: "中班", value: 1002 },
  { label: "大班", value: 1003 },
  { label: "小学", value: 7 },
  { label: "一年级", value: 1 },
  { label: "二年级", value: 2 },
  { label: "三年级", value: 3 },
  { label: "四年级", value: 4 },
  { label: "五年级", value: 5 },
  { label: "六年级", value: 6 },
  { label: "初中", value: 14 },
  { label: "初中一年级", value: 11 },
  { label: "初中二年级", value: 12 },
  { label: "初中三年级", value: 13 },
  { label: "高中", value: 104 },
  { label: "高中一年级", value: 101 },
  { label: "高中二年级", value: 102 },
  { label: "高中三年级", value: 103 }
];

// 活动参与详情性别常量
export const GENDER = [
  { label: "男", value: 1 },
  { label: "女", value: 2 }
];

export const SCENE_LIST = [
  {
    name: "全部",
    val: "all",
    active: true
  },
  {
    name: "节假日",
    val: "holiday"
  },
  {
    name: "春招",
    val: "spring"
  },
  {
    name: "夏招",
    val: "summer"
  },
  {
    name: "秋招",
    val: "autumn"
  },
  {
    name: "冬招",
    val: "winter"
  },
  {
    name: "续班",
    val: "keepClass"
  },
  {
    name: "体验课",
    val: "lesson"
  },
  {
    name: "其他",
    val: "other"
  }
];

export const TYPE_LIST = [
  {
    name: "全部",
    val: "all",
    active: true
  },
  {
    name: "微传单",
    val: "lessonType"
  },
  {
    name: "砍价",
    val: "bargainType"
  },
  {
    name: "团购",
    val: "groupType"
  },
  {
    name: "群接龙",
    val: "solitaireType"
  },
  {
    name: "集赞",
    val: "tyType"
  },
  {
    name: "微游戏",
    val: "redPackageType"
  },
  {
    name: "抽奖",
    val: "rollType"
  },
  {
    name: "投票",
    val: "voteType"
  },
  {
    name: "扭蛋机",
    val: "gachaType"
  },
  {
    name: '分销',
    val: 'distributeType'
  }
];

export const SHOW_STATUS = {
  'IN_PROGRESS': {
    status: 'IN_PROGRESS',
    label: '进行中',
    color:"rgba(47,200,60,1)"
  },
  'ENDED':{
    status: 'ENDED',
    label: '已结束',
    color:"rgba(204,204,204,1)"
  },
  'IN_VALID': {
    status: 'IN_VALID',
    label: '已失效',
    color:"rgba(204,204,204,1)"
  },
  'DELETED':{
    status: 'DELETED',
    label: '已删除',
    color:"rgba(204,204,204,1)"
  }
};