import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Tree} from "antd";
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user';
import WWOpenDataCom from '@/components/WWOpenDataCom';
import "./MemberTree.less";
import _ from 'underscore';
const { DirectoryTree } = Tree;
function MemberTree(props) {
  const [treeData,setTreeData]=useState([]);
  useEffect(()=>{
    getTreeData();
  },[]);
  function getTreeData(){
    const params = {
      depType:props.treeDepType,
      enterpriseId:User.getEnterpriseId(),
      source:0,//0代表来自企培
      storeId:User.getStoreId(),
      userId:User.getUserId(),
      whetherCount:false,
      distinct:true,
      queryType:props.type
    }
    if(props.departmentId){
      params.departmentId = props.departmentId;
    }
    if(props.nowTreeDepType){
      params.nowDepType = props.nowTreeDepType;
    }
    StoreService.getDepartmentUserNotPage(params).then((res) => {
      let { departmentVOList=[]} = res.result;
      let _treeData = handleData(departmentVOList);
      console.log("_treeData",_treeData);
      setTreeData(_treeData);
    });
  }
  function handleData(dataArray){
    const _dataArray = dataArray.map((item,index)=>{
      item.title = "";
      item.key=item.id;
      item.children = []
      if(item.departmentUserVOList){
        item.children = item.departmentUserVOList;
      }
      if(item.sonDepartmentVOList){
        item.children = [...item.children,...item.sonDepartmentVOList];
      }
      if(item.children.length > 0){
        handleData(item.children)
      }else{
        delete item.children
      }
      return item
    })
    return _dataArray;
  }
  function treeSelected (selectedKeys,e){
    const _checkedNodes = e.checkedNodes;
    const _selectNodes = [];
    _checkedNodes.map((item,index)=>{
      if(item.userId){
        _selectNodes.push(item);
      }
    })
    console.log('_selectNodes',_selectNodes);
    props.onSelect(_selectNodes);
  }
  return (
    <div className="member-tree">
      <div className="tree-con">
        <DirectoryTree
          defaultExpandAll
          checkable
          showIcon={false}
          treeData={treeData}
          checkedKeys={_.pluck(props.selectUserList, 'id')}
          onCheck={(selectedKeys,e)=>treeSelected(selectedKeys,e)}
          titleRender={(nodeData) => {
            return (
              <div
                className="node-title-con"
              >
                {nodeData.userId ?
                  <div>
                    <span className="icon iconfont title-icon">&#xe603;</span>
                    <span><WWOpenDataCom type="userName" openid={nodeData.userName}/></span>
                  </div>
                  :
                  <div>
                    <span className="icon iconfont title-icon">&#xe604;</span>
                    <span><WWOpenDataCom type="departmentName" openid={nodeData.name}/></span>
                  </div>
                }
              </div>
            );
          }}
        />
      </div>
    </div>
  );
}

export default withRouter(MemberTree);
