/*
 * @Author: 吴文洁 
 * @Date: 2020-07-14 15:42:24 
 * @Last Modified by: chenshu
 * @Last Modified time: 2021-04-12 14:40:35
 * @Description: 大班直播、互动班课的操作区
 */

import React from 'react';
import { Button, Modal, message } from 'antd';
import Service from '@/common/js/service';
import { withRouter ,Route} from "react-router-dom";
import './liveCourseOpt.less';
import BaseService from "@/domains/basic-domain/baseService";
import CreateWorkWXCourse from './CreateWorkWXCourse'
import User from '@/common/js/user'
import LiveModeSelect from './LiveModeSelect';

class LiveCourseOpt extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      isMac: /macintosh|mac os x/i.test(navigator.userAgent),
      showModeSelect: false,
    }
  }

  handleCreateLiveCouese = ()=>{
    this.setState({
      showModeSelect: true
    })
    // window.RCHistory.push({
    //   pathname: '/create-live-course?type=add',
    // })
  }

  onModeSelectClose = ()=> {
    this.setState({
      showModeSelect: false
    })
  }

  onModeSelected = (type)=> {
    this.setState({
      showModeSelect: false
    })
    if (type === 0) {
      window.RCHistory.push({
        pathname: '/create-live-course?type=add',
      })
    } else if (type === 1) {
      const { match } = this.props;
      this.props.history.push(`${match.url}/createqwcourse`)
    }
  }

  handleCreateQWCouese=()=>{
    const { match } = this.props;
    this.props.history.push(`${match.url}/createqwcourse`)

  }

  // 下载直播客户端
  handleDownloadClient = () => {
    const { isMac } = this.state;
    // 判断学员系统
    let platform;
    if(!isMac){
      platform = 1
    } else {
      platform = 4
    }
    BaseService
    .getLastedVersion({ model: 5, platform})
    .then((res) => {
      const a = document.createElement("a");
      document.body.appendChild(a);
      a.href = res.result.releaseUrl;
      a.click();
      document.body.removeChild(a);
    })
  }
  render() {
    const userRole =  User.getUserRole();
    const { match } = this.props;
    return (
      <div className="live-course-opt">
        <LiveModeSelect onClose={this.onModeSelectClose} onSelected={this.onModeSelected} isShow={this.state.showModeSelect}/>
        <div className="opt__left">
          { userRole !== "CloudLecturer" &&
            <Button type="primary" onClick={this.handleCreateLiveCouese}>新建直播课</Button>
          }
            {/* <Button type="primary" onClick={this.handleCreateQWCouese}>新建企微直播课</Button> */}
          {!this.state.isMac && <Button onClick={this.handleDownloadClient}>下载直播客户端</Button>}
        </div>
        <Route path={`${match.url}/createqwcourse`} component={CreateWorkWXCourse} />
      </div>
    )
  }
}

export default withRouter(LiveCourseOpt);