import React, { useState, useEffect } from 'react';
import { Modal, Form, Button, Input, Radio, Row, Col } from 'antd';
import _ from 'underscore';
import './IdentificationModal.less';

interface IdentificationModalProps {
    onClose:() => void,
    phone:String,
    onConfirm:() => void
}

function IdentificationModal(props: IdentificationModalProps) {
    const {onClose, phone ,onConfirm} = props;
    const [phoneVerify, setPhoneverify] = useState(''); // 验证身份的验证码
    const [codeText, setCodeText] = useState('发送验证码');
    const [checking, setChecking] = useState(false);
    const [waitStatus, setWaitStatus] = useState(false); // 验证码是否在倒计时
    //Todo
    const [errorMessageText,setErrorMessageText] =  useState('验证码有误');

    useEffect(() => {
     
    })
    function handleConfirm():any {
        if(!phoneVerify){
            setErrorMessageText('请输入验证码');
           return;
        }
        onConfirm();
    }
    function handleSendCode() {
       if (waitStatus) return;
        let timer:any;
        timeSub(60,0);
        setChecking(true)
        function timeSub(waitTime:number, unit:number):any{
            clearTimeout(timer);
            timer = setTimeout(function () {
                if (waitTime == 0) {
                setCodeText('发送验证码')
                setChecking(false)
                setWaitStatus(false)
                clearTimeout(timer);
                } else {
                setCodeText(`${waitTime}秒后重发`)
                setWaitStatus(true)
                timeSub(--waitTime, 1000);
                }
            }, unit || 0);
        }
    }
    return (
        <Modal
            visible={true}
            title="身份验证"
            width={448}
            onCancel={onClose}
            className="identification-modal"
            footer={[
                <Button
                  id='cancel_allot_btn'
                  key="back" onClick={onClose}>取消</Button>,
                <Button
                  id='confirm_allot_btn'
                  key="submit"
                  type="primary"
                  onClick={() => {
                    handleConfirm()
                  }}>
                  确认
                </Button>
              ]}
        >
     
        <div className="desc">为了你的账户安全，请验证身份。验证成功后进行下一步操作</div>
        <div className="phone">{phone}</div>
        <div className="verify-content">
            <Input
                type="text"
                name="phoneverify"
                placeholder="验证码"
                value={phoneVerify}
                onChange={(e) => { setPhoneverify(e.target.value) }}
                style={{ width:200,height:32}}
            />
            <span
                className="send-code"  
                onClick={() => {
                    if (checking) return;
                    handleSendCode();
                }}>
                {codeText}
            </span>
        </div>
        <div className="error-message">{errorMessageText}</div>
      
        </Modal>
    )
}

export default IdentificationModal;