/*
 * @Author: 吴文洁
 * @Date: 2020-04-27 20:35:34
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-23 19:38:35
 * @Description:
 */

import React, { useEffect, useState } from "react";
import ReactDOM from 'react-dom';
import { HashRouter } from 'react-router-dom';
import { ConfigProvider } from 'antd';
import { createHashHistory } from 'history';
import zh_CN from 'antd/es/locale/zh_CN';
import _ from 'underscore';
import { RootRouter } from './routes/index';
import 'antd/dist/antd.less';
import 'video-react/dist/video-react.css';
import '@/common/less/index.less';
import '@/core/function';
import User from '@/common/js/user';
import Service from "@/common/js/service";

declare var getParameterByName: any;


const history = createHashHistory();

window.RCHistory = _.extend({}, history, {
  push: (obj: any) => {
    history.push(obj)
  },
  pushState: (obj: any) => {
    history.push(obj)
  },
  pushStateWithStatus: (obj: any) => {
    history.push(obj)
  },
  goBack: history.goBack,
  location: history.location,
  replace: (obj: any) => {
    history.replace(obj)
  }
});

function mount() {
  ReactDOM.render(
    <RootRouter />,
    document.getElementById('root'));
}

if (getParameterByName('code')) {
  Service.Hades('anon/hades/wXWorkUserLogin', {
    appTermEnum: 'XIAOMAI_CLOUD_CLASS_PC_WEB_ADMIN',
    code: getParameterByName('code')
  }).then((res) => {
    User.setUserId(res.result.userId);
    User.setToken(res.result.xmToken);
    mount()
  })
} else {
  mount()
}

