import React, { useContext, useEffect, useState } from 'react';
import {
  withRouter,
} from 'react-router-dom';
import { Menu} from 'antd';
import { menuList } from '../../routes//config/menuList'
import { XMContext } from '../../store/context';
import _ from 'underscore';
import "./Menu.less";

const { SubMenu } = Menu;
function Aside(props: any) {
  const {menuType,handleMenuType}= props
  const ctx: any = useContext(XMContext);
  const [selectKey, setSelectKey] = useState();
  const [openKeys, setOpenKeys] = useState(['']);
  const rootSubmenuKeys = _.pluck(menuList, 'groupCode');
  useEffect(() => {
    const link = props.location.pathname;
    menuList.map((item: any, index: any) => {
      if (link.indexOf(item.link) !== -1) {
        setSelectKey(item.groupCode);
        setOpenKeys([])
      } else if (item.children) {
        item.children.map((_item: any, _index: any) => {
          if (link.indexOf(_item.link) !== -1) {
            setSelectKey(_item.groupCode + index + _index);
          }
        })
      }
      return item;
    })
  }, [props.location.pathname])
  function toggleMenu(item: any) {
    window.RCHistory.push(item.link)
  }
  function onOpenChange(key: any) {
    if (openKeys.includes(key)) {
      setOpenKeys([]);
    } else {
      setOpenKeys([key]);
    }
  }
  function handleMenu() {
    handleMenuType();
  }

  return (
    <div 
        id="left-container"
        className={
          menuType
            ? "left-container"
            : "left-container left-container-vertical"
        }
      >
        <div className="menu-type-icon"  onClick={handleMenu}>
          {menuType ? (
            <span
              className="icon iconfont"
            >
              &#xe83d;
            </span>
          ) : (
            <span
              className="icon iconfont"
            >
              &#xe615;
            </span>
          )}
        </div>
        <div className="left">
          <div className="nav">

        <Menu
          style={{ minHeight: "100%", background: '#0E1935' }}
          selectedKeys={selectKey}
          openKeys={openKeys}
          inlineCollapsed={false}
          mode={menuType ? "inline" : "vertical"}
        >
          {
            menuList.map((item: any, index: any) => {
              if (ctx.xmState.storeUserPermissionList.indexOf(item.groupCode) === -1) {
                return null;
              }
              if (item.children) {
                return <SubMenu key={item.groupCode} style={{ marginTop: 0 }} className="first-menu-item" title={<div > 
                    {/* <span style={{ marginRight: 16 }} className="iconfont icon" dangerouslySetInnerHTML={{ __html:item.icon}}></span> */}
                    <img src={item.img} className="icon-img"></img>
                    {menuType &&
                      <span>{item.groupName}</span>
                    }</div>
                  } onTitleClick={() => onOpenChange(item.groupCode)}>
                  {
                    item.children.map((_item: any, _index: any) => {
                      if (ctx.xmState.storeUserPermissionList.indexOf(_item.groupCode) === -1) {
                        return null;
                      }
                      return <Menu.Item onClick={() => { toggleMenu(_item) }} style={{ marginTop: 0 }} key={_item.groupCode + index + _index}>
                        <span className="name">{_item.groupName}</span>
                      </Menu.Item>

                    })
                  }
                </SubMenu>
              } else {
                return <Menu.Item onClick={() => { toggleMenu(item) }} key={item.groupCode} className="first-menu-item">
                  {/* <span style={{ marginRight: 16 }} className="iconfont icon" dangerouslySetInnerHTML={{ __html:item.icon}}></span> */}
                  {selectKey === item.groupCode ?
                    <img src={item.selectImg} className="icon-img"></img>
                    :
                    <img src={item.img} className="icon-img"></img>
                  }
                  

                  {menuType &&
                    <span>{item.groupName}</span>
                  }
                </Menu.Item>
              }
            })
          }
        </Menu>
      </div>
      </div>
    </div>
  );
}

export default withRouter(Aside);