import React, { useState, useRef, useEffect, useContext } from 'react'
import { message, Modal } from 'antd';
import { withRouter } from 'react-router-dom';
import PaperContent from '../paper-manage/PaperContent'
import './AddExam.less';
import user from '@/common/js/user';

function SelectPaperModal(props: any) {

    const [item, setItem] = useState(props.paperInfo);
    const itemRef = useRef({})

    useEffect(() => {
        itemRef.current = item
        console.log(item, 'khjkhjkhjk')
    }, [item])

    return <Modal
        width={900}
        title="选择试卷"
        visible={true}
        onOk={() => {
            props.onSelect(itemRef.current);
            props.close();
        }
        }
        onCancel={() => { props.close() }}
    >
        <PaperContent paperId={item.paperId} onSelect={(item: any) => { setItem(item) }} type='modal-select'></PaperContent>
    </Modal >
}


export default withRouter(SelectPaperModal);