import React, { useEffect, useState } from "react";
import BaseService from "@/domains/basic-domain/baseService";
import { Tooltip } from "antd"
import "./LimitTip.less"

export default function LimitTip(props:{total:number,type:string,tip:() => React.ReactNode}) {

    const [isOver, setIsOver] = useState(false)
    const [limitUser, setLimitUser] = useState(0)
  
    useEffect(()=> {
      BaseService.getLesseeVersionMsg()
      .then(res=> {
        setIsOver(res.result.surplusUserNum === 0 || res.result.whetherReachUserNum)
        setLimitUser(res.result.userNum)
      })
    },[])
  
    return (
      <div className="limit-tip">
        <div className="always">本学院{props.type}共<span style={{color:"#333333",fontWeight:"bold"}}>{props.total}</span>人
        <Tooltip overlayStyle={{maxWidth:"587px",width:"fit-content"}} placement="topLeft" arrowPointAtCenter title={props.tip}>
          <span className="icon iconfont" style={{cursor:"pointer",marginLeft:"4px",color:"#bfbfbf"}}>&#59449;</span>
        </Tooltip>
        {
          isOver ? (
            <>
            <div style={{marginLeft:"14px",display:"inline-block"}}>当前企业使用人数已达到上限 (<span style={{color:"#333333",fontWeight:"bold"}}>{limitUser}</span>人)，将无法添加新员工、新学员，如需增加人数限制，请联系小麦企学院服务平台。</div>
            <div className="renew-text">立即续费<span className="icon iconfont" style={{fontSize:"10px"}}>&#59291;</span>
            <div className="renew-popover">
            <div className="popover-arrow"><span className="popover-arrow-content"></span></div>
                <div className="qrcode">
                  <img src="https://cdn.xiaomai5.com/qixueyuankehu.png" alt=""></img>
                  <div className="des">微信/企业微信扫码续费</div>
                </div>
                <div className="phone"><svg style={{position:"relative",top:"2px",marginRight:"4px"}} viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path d="M512.651 3.78c-281.433 0-509.21 228.324-509.21 509.209 0 281.43 228.325 509.203 509.21 509.203 281.427 0 509.202-228.317 509.202-509.203 0.55-280.885-227.775-509.21-509.202-509.21z m198.205 743.553c-36.14 36.136-169.737 1.641-302.24-130.312-131.953-131.959-165.902-266.104-129.768-301.695 31.211-31.21 68.99-85.417 125.939-14.782 56.943 70.629 29.016 90.34-3.291 122.647-22.449 22.448 24.642 79.392 73.37 128.125 49.283 48.73 105.678 95.818 128.126 73.368 32.306-32.305 52.017-60.23 122.646-3.288 71.182 56.949 16.426 95.276-14.782 125.937z" p-id="4409" fill="#999999"></path></svg>
                咨询电话：19157875632</div>
              </div>
            </div>
            </>
          ) : ("")
        }
        </div>
      </div>
    )
  }