/*
 * @Author: 吴文洁
 * @Date: 2020-08-20 09:20:43
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-09 14:51:33
 * @Description: 
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */
// 限制字数
const getEllipsText = (text: string, limitNum: number) => {
  const limitText: string = text.replace(/\n/g, ' ');
  
  if (limitText.length > limitNum) {
    return `${limitText.substr(0, limitNum)}...`;
  }
  return limitText;
}

// 随机生成32位字符串
const randomString = (strLen: number = 32) => {
  const chars: string = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'
  const maxPos = chars.length;

  let pwd: string = '';
  for (let i: number = 0; i < strLen; i++) {
    pwd += chars.charAt(Math.floor(Math.random() * maxPos))
  }
  return pwd;
}

const copyText = (textContent: string) => {
  const inputDom = document.createElement('textarea')

  inputDom.value = textContent
  document.body.appendChild(inputDom)
  inputDom.select()
  document.execCommand('copy')
  document.body.removeChild(inputDom)
}

const formatDate = (format: string, timestamp: string) => {
  if (!timestamp) return;
  
  const date = new Date(parseInt(timestamp))
  let y: any = date.getFullYear(),
    m: any = date.getMonth() + 1,
    d: any = date.getDate(),
    h: any = date.getHours(),
    i: any = date.getMinutes(),
    s: any = date.getSeconds(),
    w: number = date.getDay(),
    week: string[] = ['周日', '周一', '周二', '周三', '周四', '周五', '周六']

  m = m < 10 ? '0' + m : m;
  d = d < 10 ? '0' + d : d;
  h = h < 10 ? '0' + h : h;
  i = i < 10 ? '0' + i : i;
  s = s < 10 ? '0' + s : s;
  return format
    .replace('YYYY', y)
    .replace('MM', m)
    .replace('DD', d)
    .replace('H', h)
    .replace('i', i)
    .replace('s', s)
    .replace('WW', week[w])
}

export {
  getEllipsText,
  randomString,
  copyText,
  formatDate
}