/*
 * @Author: yuananting
 * @Date: 2021-07-29 13:57:03
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-29 15:57:33
 * @Description: 任务中心-培训任务-新建页面
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from 'react';
import { Button, Tabs, message, Modal } from 'antd';
import ShowTips from '@/components/ShowTips';
import Breadcrumbs from '@/components/Breadcrumbs';
import BasicInfo from './components/BasicInfo';
// import TrainingTask from './components/TrainingTask';
// import ExpiredCourseList from './components/ExpiredCourseList';
import PlanService from '@/domains/plan-domain/planService';
import User from '@/common/js/user';
import _ from 'underscore';
import './AddTrainTask.less';
import Bus from '@/core/bus';
const { TabPane } = Tabs;

const defaultCover = 'https://image.xiaomaiketang.com/xm/rEAetaTEh3.png';

const DEFAULT_BASIC_INFO = {
  planName: '',
  coverUrl: defaultCover,
  coverId: null,
  durationType: 'NEVER_EXPIRES',
  enableState: 'YES',
  selectOperatorList: [],
  instro: '',
  operateType: 'All_Operate',
  percentCompleteLive: 80,
  percentCompleteVideo: 80,
  percentCompletePicture: 100,
};

function AddTrainTask() {
  const type = getParameterByName('type');
  const [activeStep, setActiveStep] = useState('BASIC_INFO');
  const [basicInfo, setBasicInfo] = useState(DEFAULT_BASIC_INFO);

  function renderFooter() {
    return (
      <Choose>
        <When condition={activeStep === 'BASIC_INFO'}>
          <div className='footer shrink-footer'>
            <Button onClick={handleGoBack}>取消</Button>
            <Button onClick={() => console.log('提交')}>保存</Button>
            <Button type='primary' onClick={() => console.log('下一步')}>
              下一步
            </Button>
            {/* disabled={submitDisabled} */}
          </div>
        </When>
        <Otherwise>
          <div className='footer shrink-footer'>
            <Button onClick={handleGoBack}>取消</Button>
            <Button onClick={() => console.log('上一步')}>上一步</Button>
            <Button onClick={() => console.log('提交')}>保存</Button>
            <Button type='primary' onClick={() => console.log('提交')}>
              保存并发布
            </Button>
            {/* disabled={submitDisabled} */}
          </div>
        </Otherwise>
      </Choose>
    );
  }
  function handleGoBack() {
    window.RCHistory.goBack();
  }

  function handleChangeBasicInfo(field, value) {
    setBasicInfo({
      ...basicInfo,
      [field]: value,
    });
  }

  return (
    <div className='page add-train-task'>
      <Breadcrumbs navList={type == 'add' ? '新建培训任务' : '编辑培训任务'} goBack={handleGoBack} />
      <div className='box'>
        <div className='show-tips'>
          <ShowTips message='请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企学院保有依据国家规定及平台规则进行处理的权利' />
        </div>
        <Tabs centered={true} onChange={(key) => setActiveStep(key)}>
          <TabPane tab='1  基本信息' key='BASIC_INFO'>
            <BasicInfo data={basicInfo} onChange={handleChangeBasicInfo} />
          </TabPane>
          <TabPane tab='2  培训内容' key='TRAIN_CONTENT'>
            <div className='train-content__warp'>2</div>
          </TabPane>
        </Tabs>
      </div>
      {renderFooter()}
    </div>
  );
}

export default AddTrainTask;
